/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.committed.VcsConfigurationChangeListener;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PairConsumer;
import com.intellij.util.messages.MessageBus;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBranchConfiguration;
import org.jetbrains.idea.svn.SvnBranchMapperManager;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.branchConfig.InfoReliability;
import org.jetbrains.idea.svn.branchConfig.InfoStorage;
import org.jetbrains.idea.svn.branchConfig.NewRootBunch;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigManager;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.integrate.SvnBranchItem;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;

@State(name="SvnBranchConfigurationManager", storages={@Storage(id="other", file="$PROJECT_FILE$")})
public class SvnBranchConfigurationManager
implements PersistentStateComponent<ConfigurationBean> {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.SvnBranchConfigurationManager");
    private final Project myProject;
    private final ProjectLevelVcsManager myVcsManager;
    private ConfigurationBean myConfigurationBean = new ConfigurationBean();
    private final SvnBranchConfigManager myBunch;

    public SvnBranchConfigurationManager(Project project, ProjectLevelVcsManager vcsManager) {
        this.myProject = project;
        this.myVcsManager = vcsManager;
        this.myBunch = new NewRootBunch(project);
    }

    public static SvnBranchConfigurationManager getInstance(Project project) {
        return (SvnBranchConfigurationManager)ServiceManager.getService((Project)project, SvnBranchConfigurationManager.class);
    }

    public Long getSupportValue() {
        return this.myConfigurationBean.myVersion;
    }

    public SvnBranchConfigurationNew get(@NotNull VirtualFile vcsRoot) throws VcsException {
        if (vcsRoot == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/svn/SvnBranchConfigurationManager.get must not be null");
        }
        return this.myBunch.getConfig(vcsRoot);
    }

    public SvnBranchConfigManager getSvnBranchConfigManager() {
        return this.myBunch;
    }

    public void setConfiguration(VirtualFile vcsRoot, SvnBranchConfigurationNew configuration) {
        this.myBunch.updateForRoot(vcsRoot, new InfoStorage<SvnBranchConfigurationNew>(configuration, InfoReliability.setByUser), new BranchesPreloader(this.myProject, this.myBunch, vcsRoot));
        SvnBranchMapperManager.getInstance().notifyBranchesChanged(this.myProject, vcsRoot, configuration);
        MessageBus messageBus = this.myProject.getMessageBus();
        ((VcsConfigurationChangeListener.Notification)messageBus.syncPublisher(VcsConfigurationChangeListener.BRANCHES_CHANGED)).execute(this.myProject, vcsRoot);
    }

    public ConfigurationBean getState() {
        ConfigurationBean result = new ConfigurationBean();
        result.myVersion = this.myConfigurationBean.myVersion;
        UrlSerializationHelper helper = new UrlSerializationHelper(SvnVcs.getInstance(this.myProject));
        for (VirtualFile root : this.myBunch.getMapCopy().keySet()) {
            String key = root.getPath();
            SvnBranchConfigurationNew configOrig = this.myBunch.getConfig(root);
            SvnBranchConfiguration configuration = new SvnBranchConfiguration();
            configuration.setTrunkUrl(configOrig.getTrunkUrl());
            configuration.setUserinfoInUrl(configOrig.isUserinfoInUrl());
            configuration.setBranchUrls(configOrig.getBranchUrls());
            HashMap<String, List<SvnBranchItem>> map = new HashMap<String, List<SvnBranchItem>>();
            Map<String, InfoStorage<List<SvnBranchItem>>> origMap = configOrig.getBranchMap();
            for (String origKey : origMap.keySet()) {
                map.put(origKey, origMap.get(origKey).getValue());
            }
            configuration.setBranchMap(map);
            result.myConfigurationMap.put(key, helper.prepareForSerialization(configuration));
        }
        result.mySupportsUserInfoFilter = true;
        return result;
    }

    public void loadState(ConfigurationBean object) {
        UrlSerializationHelper helper = new UrlSerializationHelper(SvnVcs.getInstance(this.myProject));
        Map<String, SvnBranchConfiguration> map = object.myConfigurationMap;
        HashMap newMap = new HashMap(map.size(), 1.0f);
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        final HashSet<Pair> whatToInit = new HashSet<Pair>();
        for (Map.Entry<String, SvnBranchConfiguration> entry : map.entrySet()) {
            SvnBranchConfiguration configuration = entry.getValue();
            VirtualFile root = lfs.refreshAndFindFileByIoFile(new File(entry.getKey()));
            if (root == null) {
                LOG.info("root not found: " + entry.getKey());
                continue;
            }
            SvnBranchConfiguration configToConvert = !this.myConfigurationBean.mySupportsUserInfoFilter || configuration.isUserinfoInUrl() ? helper.afterDeserialization(entry.getKey(), configuration) : configuration;
            SvnBranchConfigurationNew newConfig = new SvnBranchConfigurationNew();
            newConfig.setTrunkUrl(configToConvert.getTrunkUrl());
            newConfig.setUserinfoInUrl(configToConvert.isUserinfoInUrl());
            Map<String, List<SvnBranchItem>> oldMap = configToConvert.getBranchMap();
            for (String branchUrl : configToConvert.getBranchUrls()) {
                List<SvnBranchItem> items = oldMap.get(branchUrl);
                items = items == null || items.isEmpty() ? new ArrayList() : items;
                whatToInit.add(new Pair((Object)root, (Object)newConfig));
                newConfig.addBranches(branchUrl, new InfoStorage<List<SvnBranchItem>>(items, items.isEmpty() ? InfoReliability.defaultValues : InfoReliability.setByUser));
            }
            this.myBunch.updateForRoot(root, new InfoStorage<SvnBranchConfigurationNew>(newConfig, InfoReliability.setByUser), null);
        }
        ((ProjectLevelVcsManagerImpl)this.myVcsManager).addInitializationRequest(VcsInitObject.BRANCHES, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            for (Pair pair : whatToInit) {
                                BranchesPreloader branchesPreloader = new BranchesPreloader(SvnBranchConfigurationManager.this.myProject, SvnBranchConfigurationManager.this.myBunch, (VirtualFile)pair.getFirst());
                                branchesPreloader.setAll(true);
                                branchesPreloader.loadImpl(null, (SvnBranchConfigurationNew)pair.getSecond());
                            }
                        }
                        catch (ProcessCanceledException processCanceledException) {
                            // empty catch block
                        }
                    }
                });
            }
        });
        object.myConfigurationMap.clear();
        object.myConfigurationMap.putAll(newMap);
        this.myConfigurationBean = object;
    }

    private static class UrlSerializationHelper {
        private final SvnVcs myVcs;

        private UrlSerializationHelper(SvnVcs vcs) {
            this.myVcs = vcs;
        }

        public SvnBranchConfiguration prepareForSerialization(SvnBranchConfiguration configuration) {
            Ref withUserInfo = new Ref();
            String trunkUrl = this.serializeUrl(configuration.getTrunkUrl(), (Ref<Boolean>)withUserInfo);
            if (Boolean.FALSE.equals(withUserInfo.get())) {
                return configuration;
            }
            List<String> branches = configuration.getBranchUrls();
            ArrayList<String> newBranchesList = new ArrayList<String>(branches.size());
            for (String s : branches) {
                newBranchesList.add(this.serializeUrl(s, (Ref<Boolean>)withUserInfo));
            }
            Map<String, List<SvnBranchItem>> map = configuration.getBranchMap();
            HashMap<String, List<SvnBranchItem>> newMap = new HashMap<String, List<SvnBranchItem>>(map.size(), 1.0f);
            for (Map.Entry<String, List<SvnBranchItem>> entry : map.entrySet()) {
                List<SvnBranchItem> items = entry.getValue();
                if (items == null) continue;
                ArrayList<SvnBranchItem> newItems = new ArrayList<SvnBranchItem>();
                for (SvnBranchItem item : items) {
                    newItems.add(new SvnBranchItem(this.serializeUrl(item.getUrl(), (Ref<Boolean>)withUserInfo), new Date(item.getCreationDateMillis()), item.getRevision()));
                }
                newMap.put(this.serializeUrl(entry.getKey(), (Ref<Boolean>)withUserInfo), newItems);
            }
            SvnBranchConfiguration result = new SvnBranchConfiguration();
            result.setTrunkUrl(trunkUrl);
            result.setBranchUrls(newBranchesList);
            result.setBranchMap(newMap);
            result.setUserinfoInUrl(withUserInfo.isNull() ? false : (Boolean)withUserInfo.get());
            return result;
        }

        public SvnBranchConfiguration afterDeserialization(String path, SvnBranchConfiguration configuration) {
            if (!configuration.isUserinfoInUrl()) {
                return configuration;
            }
            String userInfo = this.getUserInfo(path);
            if (userInfo == null) {
                return configuration;
            }
            String newTrunkUrl = this.deserializeUrl(configuration.getTrunkUrl(), userInfo);
            List<String> branches = configuration.getBranchUrls();
            ArrayList<String> newBranchesList = new ArrayList<String>(branches.size());
            for (String s : branches) {
                newBranchesList.add(this.deserializeUrl(s, userInfo));
            }
            Map<String, List<SvnBranchItem>> map = configuration.getBranchMap();
            HashMap<String, List<SvnBranchItem>> newMap = new HashMap<String, List<SvnBranchItem>>(map.size(), 1.0f);
            for (Map.Entry<String, List<SvnBranchItem>> entry : map.entrySet()) {
                List<SvnBranchItem> items = entry.getValue();
                if (items == null) continue;
                ArrayList<SvnBranchItem> newItems = new ArrayList<SvnBranchItem>();
                for (SvnBranchItem item : items) {
                    newItems.add(new SvnBranchItem(this.deserializeUrl(item.getUrl(), userInfo), new Date(item.getCreationDateMillis()), item.getRevision()));
                }
                newMap.put(this.deserializeUrl(entry.getKey(), userInfo), newItems);
            }
            SvnBranchConfiguration result = new SvnBranchConfiguration();
            result.setTrunkUrl(newTrunkUrl);
            result.setBranchUrls(newBranchesList);
            result.setBranchMap(newMap);
            result.setUserinfoInUrl(userInfo != null && userInfo.length() > 0);
            return result;
        }

        private String serializeUrl(String url, Ref<Boolean> withUserInfo) {
            if (Boolean.FALSE.equals(withUserInfo.get())) {
                return url;
            }
            try {
                SVNURL svnurl = SVNURL.parseURIEncoded((String)url);
                if (withUserInfo.isNull()) {
                    String userInfo = svnurl.getUserInfo();
                    withUserInfo.set((Object)(userInfo != null && userInfo.length() > 0 ? 1 : 0));
                }
                if (((Boolean)withUserInfo.get()).booleanValue()) {
                    return SVNURL.create((String)svnurl.getProtocol(), null, (String)svnurl.getHost(), (int)svnurl.getPort(), (String)svnurl.getURIEncodedPath(), (boolean)true).toString();
                }
            }
            catch (SVNException sVNException) {
                // empty catch block
            }
            return url;
        }

        @Nullable
        private String getUserInfo(String path) {
            SVNURL svnurl = this.myVcs.getSvnFileUrlMapping().getUrlForFile(new File(path));
            return svnurl != null ? svnurl.getUserInfo() : null;
        }

        private String deserializeUrl(String url, String userInfo) {
            try {
                SVNURL svnurl = SVNURL.parseURIEncoded((String)url);
                return SVNURL.create((String)svnurl.getProtocol(), (String)userInfo, (String)svnurl.getHost(), (int)svnurl.getPort(), (String)svnurl.getURIEncodedPath(), (boolean)true).toString();
            }
            catch (SVNException e) {
                return url;
            }
        }
    }

    private static class BranchesPreloader
    implements PairConsumer<SvnBranchConfigurationNew, SvnBranchConfigurationNew> {
        private final Project myProject;
        private final VirtualFile myRoot;
        private final SvnBranchConfigManager myBunch;
        private boolean myAll;

        public BranchesPreloader(Project project, @NotNull SvnBranchConfigManager bunch, VirtualFile root) {
            if (bunch == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/svn/SvnBranchConfigurationManager$BranchesPreloader.<init> must not be null");
            }
            this.myBunch = bunch;
            this.myProject = project;
            this.myRoot = root;
        }

        public void consume(final SvnBranchConfigurationNew prev, final SvnBranchConfigurationNew next) {
            Application application = ApplicationManager.getApplication();
            application.executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    BranchesPreloader.this.loadImpl(prev, next);
                }
            });
        }

        protected void loadImpl(SvnBranchConfigurationNew prev, SvnBranchConfigurationNew next) {
            HashSet<String> oldUrls = prev == null ? Collections.emptySet() : new HashSet<String>(prev.getBranchUrls());
            SvnVcs vcs = SvnVcs.getInstance(this.myProject);
            if (!vcs.isVcsBackgroundOperationsAllowed(this.myRoot)) {
                return;
            }
            for (String newBranchUrl : next.getBranchUrls()) {
                if (!vcs.isVcsBackgroundOperationsAllowed(this.myRoot)) {
                    return;
                }
                if (!this.myAll && oldUrls.contains(newBranchUrl)) continue;
                new NewRootBunch.BranchesLoadRunnable(this.myProject, this.myBunch, newBranchUrl, InfoReliability.defaultValues, this.myRoot, null).run();
            }
        }

        public void setAll(boolean all) {
            this.myAll = all;
        }
    }

    public static class ConfigurationBean {
        public Map<String, SvnBranchConfiguration> myConfigurationMap = new HashMap<String, SvnBranchConfiguration>();
        public Long myVersion;
        public boolean mySupportsUserInfoFilter;
    }
}

