/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.BasicAction;
import org.jetbrains.idea.svn.ignore.IgnoreInfoGetter;
import org.jetbrains.idea.svn.ignore.SvnPropertyService;

public class AddToIgnoreListAction
extends BasicAction {
    private String myActionName;
    private final boolean myUseCommonExtension;
    private final IgnoreInfoGetter myInfoGetter;

    public AddToIgnoreListAction(IgnoreInfoGetter infoGetter, boolean useCommonExtension) {
        this.myInfoGetter = infoGetter;
        this.myUseCommonExtension = useCommonExtension;
    }

    public void setActionText(String name) {
        this.myActionName = name;
    }

    @Override
    protected String getActionName(AbstractVcs vcs) {
        return SvnBundle.message("action.name.ignore.files", new Object[0]);
    }

    @Override
    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        presentation.setVisible(true);
        presentation.setEnabled(true);
        presentation.setText(this.myActionName);
        presentation.setDescription(SvnBundle.message(this.myUseCommonExtension ? "action.Subversion.Ignore.MatchExtension.description" : "action.Subversion.Ignore.ExactMatch.description", this.myActionName));
    }

    @Override
    protected void doVcsRefresh(Project project, VirtualFile file) {
        VcsDirtyScopeManager vcsDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)project);
        if (file != null && file.getParent() != null) {
            vcsDirtyScopeManager.fileDirty(file.getParent());
        }
    }

    @Override
    protected boolean isEnabled(Project project, SvnVcs vcs, VirtualFile file) {
        return true;
    }

    @Override
    protected boolean needsFiles() {
        return true;
    }

    @Override
    protected void perform(Project project, SvnVcs activeVcs, VirtualFile file, DataContext context) throws VcsException {
    }

    @Override
    protected void batchPerform(Project project, SvnVcs activeVcs, VirtualFile[] file, DataContext context) throws VcsException {
        SvnPropertyService.doAddToIgnoreProperty(activeVcs, project, this.myUseCommonExtension, file, this.myInfoGetter);
    }

    @Override
    protected boolean isBatchAction() {
        return true;
    }
}

