/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.branchConfig.InfoStorage;
import org.jetbrains.idea.svn.integrate.SvnBranchItem;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SvnBranchConfigurationNew {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew");
    private String myTrunkUrl = "";
    public Map<String, InfoStorage<List<SvnBranchItem>>> myBranchMap = new HashMap<String, InfoStorage<List<SvnBranchItem>>>();
    private boolean myUserinfoInUrl;

    public boolean isUserinfoInUrl() {
        return this.myUserinfoInUrl;
    }

    public void setUserinfoInUrl(boolean userinfoInUrl) {
        this.myUserinfoInUrl = userinfoInUrl;
    }

    public void setTrunkUrl(String trunkUrl) {
        this.myTrunkUrl = trunkUrl;
    }

    public String getTrunkUrl() {
        return this.myTrunkUrl;
    }

    public List<String> getBranchUrls() {
        ArrayList<String> result = new ArrayList<String>(this.myBranchMap.keySet());
        Collections.sort(result);
        return result;
    }

    public void addBranches(String branchParentName, InfoStorage<List<SvnBranchItem>> items) {
        InfoStorage<List<SvnBranchItem>> current = this.myBranchMap.get(branchParentName);
        if (current != null) {
            LOG.info("Branches list not added for : '" + branchParentName + "; this branch parent URL is already present.");
            return;
        }
        this.myBranchMap.put(branchParentName, items);
    }

    public void updateBranch(String branchParentName, InfoStorage<List<SvnBranchItem>> items) {
        InfoStorage<List<SvnBranchItem>> current = this.myBranchMap.get(branchParentName);
        if (current == null) {
            LOG.info("Branches list not updated for : '" + branchParentName + "; since config has changed.");
            return;
        }
        current.accept(items, null);
    }

    public Map<String, InfoStorage<List<SvnBranchItem>>> getBranchMap() {
        return this.myBranchMap;
    }

    public List<SvnBranchItem> getBranches(String url) {
        return this.myBranchMap.get(url).getValue();
    }

    public SvnBranchConfigurationNew copy() {
        SvnBranchConfigurationNew result = new SvnBranchConfigurationNew();
        result.myUserinfoInUrl = this.myUserinfoInUrl;
        result.myTrunkUrl = this.myTrunkUrl;
        result.myBranchMap = new HashMap<String, InfoStorage<List<SvnBranchItem>>>();
        for (Map.Entry<String, InfoStorage<List<SvnBranchItem>>> entry : this.myBranchMap.entrySet()) {
            InfoStorage<List<SvnBranchItem>> infoStorage = entry.getValue();
            result.myBranchMap.put(entry.getKey(), new InfoStorage(new ArrayList(infoStorage.getValue()), infoStorage.getInfoReliability()));
        }
        return result;
    }

    @Nullable
    public String getBaseUrl(String url) {
        if (this.myTrunkUrl != null && url.startsWith(this.myTrunkUrl)) {
            return this.myTrunkUrl;
        }
        for (String branchUrl : this.myBranchMap.keySet()) {
            if (!url.startsWith(branchUrl)) continue;
            int pos = url.indexOf(47, branchUrl.length() + 1);
            if (pos >= 0) {
                return url.substring(0, pos);
            }
            return branchUrl;
        }
        return null;
    }

    @Nullable
    public String getBaseName(String url) {
        String baseUrl = this.getBaseUrl(url);
        if (baseUrl == null) {
            return null;
        }
        if (this.myBranchMap.isEmpty()) {
            return baseUrl;
        }
        int commonPrefixLength = SvnBranchConfigurationNew.getCommonPrefixLength(url, this.myTrunkUrl);
        for (String branchUrl : this.myBranchMap.keySet()) {
            if ((commonPrefixLength = Math.min(commonPrefixLength, SvnBranchConfigurationNew.getCommonPrefixLength(url, branchUrl))) > 0) continue;
            return baseUrl;
        }
        return baseUrl.substring(commonPrefixLength);
    }

    private static int getCommonPrefixLength(String s1, String s2) {
        int minLength = Math.min(s1.length(), s2.length());
        for (int i = 0; i < minLength; ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            return i;
        }
        return minLength;
    }

    @Nullable
    public String getRelativeUrl(String url) {
        String baseUrl = this.getBaseUrl(url);
        return baseUrl == null ? null : url.substring(baseUrl.length());
    }

    @Nullable
    public SVNURL getWorkingBranch(SVNURL someUrl) throws SVNException {
        BranchSearcher branchSearcher = new BranchSearcher(someUrl);
        this.iterateUrls(branchSearcher);
        return branchSearcher.getResult();
    }

    @Nullable
    public String getGroupToLoadToReachUrl(SVNURL url) throws SVNException {
        BranchSearcher branchSearcher = new BranchSearcher(url);
        for (String group : this.myBranchMap.keySet()) {
            if (!branchSearcher.accept(group)) continue;
            return group;
        }
        return null;
    }

    private void iterateUrls(UrlListener listener) throws SVNException {
        if (listener.accept(this.myTrunkUrl)) {
            return;
        }
        for (String branchUrl : this.myBranchMap.keySet()) {
            List<SvnBranchItem> children = this.myBranchMap.get(branchUrl).getValue();
            for (SvnBranchItem child : children) {
                if (!listener.accept(child.getUrl())) continue;
                return;
            }
        }
    }

    @Nullable
    public Map<String, String> getUrl2FileMappings(Project project, VirtualFile root) {
        try {
            BranchRootSearcher searcher = new BranchRootSearcher(SvnVcs.getInstance(project), root);
            this.iterateUrls(searcher);
            return searcher.getBranchesUnder();
        }
        catch (SVNException e) {
            return null;
        }
    }

    public void removeBranch(String url) {
        this.myBranchMap.remove(url);
    }

    @Nullable
    private static SVNURL urlIsParent(String parentCandidate, SVNURL child) throws SVNException {
        SVNURL parentUrl = SVNURL.parseURIEncoded((String)parentCandidate);
        if (parentUrl.equals((Object)SVNURLUtil.getCommonURLAncestor((SVNURL)parentUrl, (SVNURL)child))) {
            return parentUrl;
        }
        return null;
    }

    private static class BranchSearcher
    implements UrlListener {
        private final SVNURL mySomeUrl;
        private SVNURL myResult;

        private BranchSearcher(SVNURL someUrl) {
            this.mySomeUrl = someUrl;
        }

        @Override
        public boolean accept(String url) throws SVNException {
            this.myResult = SvnBranchConfigurationNew.urlIsParent(url, this.mySomeUrl);
            return this.myResult != null;
        }

        public SVNURL getResult() {
            return this.myResult;
        }
    }

    private static interface UrlListener {
        public boolean accept(String var1) throws SVNException;
    }

    private static class BranchRootSearcher
    implements UrlListener {
        private final VirtualFile myRoot;
        private final SVNURL myRootUrl;
        private final Map<String, String> myBranchesUnder;

        private BranchRootSearcher(SvnVcs vcs, VirtualFile root) throws SVNException {
            this.myRoot = root;
            this.myBranchesUnder = new HashMap<String, String>();
            SVNWCClient client = vcs.createWCClient();
            SVNInfo info = client.doInfo(new File(this.myRoot.getPath()), SVNRevision.WORKING);
            this.myRootUrl = info.getURL();
        }

        @Override
        public boolean accept(String url) throws SVNException {
            if (this.myRootUrl != null) {
                File baseDir = new File(this.myRoot.getPath());
                String baseUrl = this.myRootUrl.getPath();
                SVNURL branchUrl = SVNURL.parseURIEncoded((String)url);
                if (this.myRootUrl.equals((Object)SVNURLUtil.getCommonURLAncestor((SVNURL)this.myRootUrl, (SVNURL)branchUrl))) {
                    File file = SvnUtil.fileFromUrl(baseDir, baseUrl, branchUrl.getPath());
                    this.myBranchesUnder.put(url, file.getAbsolutePath());
                }
            }
            return false;
        }

        public Map<String, String> getBranchesUnder() {
            return this.myBranchesUnder;
        }
    }
}

