/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.util.Consumer;
import java.io.File;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.integrate.IMerger;
import org.jetbrains.idea.svn.update.UpdateEventHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class BranchMerger
implements IMerger {
    private final SvnVcs myVcs;
    private final String myTargetPath;
    private final SVNURL mySourceUrl;
    private final SVNURL myTargetUrl;
    private final UpdateEventHandler myHandler;
    private final boolean myReintegrate;
    private final String myBranchName;
    private final long mySourceCopyRevision;
    private boolean myAtStart;
    private long mySourceLatestRevision;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BranchMerger(SvnVcs vcs, SVNURL sourceUrl, SVNURL targetUrl, String targetPath, UpdateEventHandler handler, boolean isReintegrate, String branchName, long sourceCopyRevision) {
        this.myVcs = vcs;
        this.myTargetPath = targetPath;
        this.mySourceUrl = sourceUrl;
        this.myTargetUrl = targetUrl;
        this.myHandler = handler;
        this.myReintegrate = isReintegrate;
        this.myBranchName = branchName;
        this.mySourceCopyRevision = sourceCopyRevision;
        this.myAtStart = true;
        SVNRepository repository = null;
        try {
            repository = this.myVcs.createRepository(this.mySourceUrl);
            this.mySourceLatestRevision = repository.getLatestRevision();
        }
        catch (SVNException e) {
            this.mySourceLatestRevision = SVNRevision.HEAD.getNumber();
        }
        finally {
            if (repository != null) {
                repository.closeSession();
            }
        }
    }

    @Override
    public String getComment() {
        return "Merge all from " + this.myBranchName + " at " + this.mySourceLatestRevision + (this.myReintegrate ? " (reintegration)" : "");
    }

    @Override
    public boolean hasNext() {
        return this.myAtStart;
    }

    @Override
    public void mergeNext() throws SVNException {
        this.myAtStart = false;
        SVNDiffClient dc = this.myVcs.createDiffClient();
        dc.setEventHandler((ISVNEventHandler)this.myHandler);
        SvnConfiguration svnConfig = SvnConfiguration.getInstanceChecked(this.myVcs.getProject());
        dc.setMergeOptions(new SVNDiffOptions(svnConfig.IGNORE_SPACES_IN_MERGE, svnConfig.IGNORE_SPACES_IN_MERGE, svnConfig.IGNORE_SPACES_IN_MERGE));
        if (this.myReintegrate) {
            dc.doMergeReIntegrate(this.mySourceUrl, SVNRevision.UNDEFINED, new File(this.myTargetPath), false);
        } else {
            dc.doMerge(this.mySourceUrl, SVNRevision.create((long)this.mySourceCopyRevision), this.mySourceUrl, SVNRevision.create((long)this.mySourceLatestRevision), new File(this.myTargetPath), SVNDepth.INFINITY, true, true, false, false);
        }
    }

    @Override
    public void getInfo(Consumer<String> holder, boolean getLatest) {
    }

    @Override
    public File getMergeInfoHolder() {
        return new File(this.myTargetPath);
    }

    @Override
    public void afterProcessing() {
    }

    @Override
    public void getSkipped(Consumer<String> holder) {
    }
}

