/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.DocumentAdapter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SetPropertyDialog
extends DialogWrapper {
    private final String myPropertyName;
    private final File[] myFiles;
    private JComboBox myPropertyNameBox;
    private JRadioButton mySetPropertyButton;
    private JTextArea myValueText;
    private JRadioButton myDeletePropertyButton;
    private JCheckBox myRecursiveButton;
    private final boolean myIsRecursionAllowed;
    private final SvnVcs myVCS;
    @NonNls
    private static final String HELP_ID = "vcs.subversion.property";
    private JPanel myMainPanel;

    public SetPropertyDialog(Project project, File[] files, String name, boolean allowRecursion) {
        super(project, true);
        this.myFiles = files;
        this.myPropertyName = name;
        this.myIsRecursionAllowed = allowRecursion;
        this.$$$setupUI$$$();
        this.myVCS = SvnVcs.getInstance(project);
        this.setResizable(true);
        this.setTitle(SvnBundle.message("dialog.title.set.property", new Object[0]));
        this.getHelpAction().setEnabled(true);
        this.init();
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(HELP_ID);
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPropertyNameBox;
    }

    public String getPropertyName() {
        return (String)this.myPropertyNameBox.getEditor().getItem();
    }

    public String getPropertyValue() {
        if (this.myDeletePropertyButton.isSelected()) {
            return null;
        }
        return this.myValueText.getText();
    }

    public boolean isRecursive() {
        return this.myRecursiveButton.isSelected();
    }

    public boolean shouldCloseOnCross() {
        return true;
    }

    protected String getDimensionServiceKey() {
        return "svn.propertyDialog";
    }

    protected void init() {
        super.init();
        if (this.myPropertyName != null) {
            this.updatePropertyValue(this.myPropertyName);
        } else {
            this.myPropertyNameBox.getEditor().setItem("");
        }
        this.myPropertyNameBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String name = SetPropertyDialog.this.getPropertyName();
                    SetPropertyDialog.this.updatePropertyValue(name);
                    SetPropertyDialog.this.getOKAction().setEnabled(name != null && !"".equals(name.trim()));
                }
            }
        });
        Component editor = this.myPropertyNameBox.getEditor().getEditorComponent();
        if (editor instanceof JTextField) {
            JTextField jTextField = (JTextField)editor;
            jTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    String name = SetPropertyDialog.this.getPropertyName();
                    SetPropertyDialog.this.updatePropertyValue(name);
                    SetPropertyDialog.this.getOKAction().setEnabled(name != null && !"".equals(name.trim()));
                }
            });
        }
        this.getOKAction().setEnabled(this.myPropertyName != null && !"".equals(this.myPropertyName.trim()));
    }

    private void updatePropertyValue(String name) {
        SVNPropertyData property;
        if (this.myFiles.length == 0 || this.myFiles.length > 1) {
            return;
        }
        File file = this.myFiles[0];
        try {
            SVNWCClient client = this.myVCS.createWCClient();
            property = client.doGetProperty(file, name, SVNRevision.WORKING, SVNRevision.WORKING);
        }
        catch (SVNException e) {
            property = null;
        }
        if (property != null) {
            this.myValueText.setText(SVNPropertyValue.getPropertyAsString((SVNPropertyValue)property.getValue()));
            this.myValueText.selectAll();
        } else {
            this.myValueText.setText("");
        }
    }

    protected JComponent createCenterPanel() {
        this.fillPropertyNames(this.myFiles);
        if (this.myPropertyName != null) {
            this.myPropertyNameBox.getEditor().setItem(this.myPropertyName);
            this.myPropertyNameBox.getEditor().selectAll();
        }
        this.mySetPropertyButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (SetPropertyDialog.this.mySetPropertyButton.isSelected()) {
                    SetPropertyDialog.this.myValueText.setEnabled(true);
                    SetPropertyDialog.this.myValueText.requestFocus();
                } else {
                    SetPropertyDialog.this.myValueText.setEnabled(false);
                }
            }
        });
        this.myRecursiveButton.setEnabled(this.myIsRecursionAllowed);
        return this.myMainPanel;
    }

    private void fillPropertyNames(File[] files) {
        final TreeSet<String> names = new TreeSet<String>();
        if (files.length == 1) {
            File file = files[0];
            try {
                SVNWCClient client = this.myVCS.createWCClient();
                client.doGetProperty(file, null, SVNRevision.WORKING, SVNRevision.WORKING, false, new ISVNPropertyHandler(){

                    public void handleProperty(File path, SVNPropertyData property) {
                        String name = property.getName();
                        if (name != null) {
                            names.add(name);
                        }
                    }

                    public void handleProperty(SVNURL url, SVNPropertyData property) {
                    }

                    public void handleProperty(long revision, SVNPropertyData property) {
                    }
                });
            }
            catch (SVNException e) {
                // empty catch block
            }
        }
        SetPropertyDialog.fillProperties(names);
        for (String name : names) {
            this.myPropertyNameBox.addItem(name);
        }
    }

    private static void fillProperties(Collection<String> names) {
        names.add("svn:eol-style");
        names.add("svn:keywords");
        names.add("svn:needs-lock");
        names.add("svn:mime-type");
        names.add("svn:executable");
        names.add("svn:ignore");
        names.add("svn:externals");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JRadioButton jRadioButton;
        JTextArea jTextArea;
        JRadioButton jRadioButton2;
        JComboBox jComboBox;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("label.set.property.property.name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.myPropertyNameBox = jComboBox = new JComboBox();
        jComboBox.setRequestFocusEnabled(false);
        jComboBox.setEditable(true);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
        jPanel.add(jComboBox, gridBagConstraints2);
        this.mySetPropertyButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("radio.set.property.set.property.value"));
        jRadioButton2.setSelected(true);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.gridwidth = 2;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jRadioButton2, gridBagConstraints3);
        JScrollPane jScrollPane = new JScrollPane();
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 2;
        gridBagConstraints4.gridwidth = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.weighty = 1.0;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jScrollPane, gridBagConstraints4);
        this.myValueText = jTextArea = new JTextArea();
        jTextArea.setText("");
        jTextArea.setRows(7);
        jTextArea.setColumns(25);
        jScrollPane.setViewportView(jTextArea);
        this.myDeletePropertyButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("radio.set.property.delete.property"));
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 3;
        gridBagConstraints5.gridwidth = 2;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jRadioButton, gridBagConstraints5);
        JSeparator jSeparator = new JSeparator();
        ((Component)jSeparator).setFont(UIManager.getFont("TextPane.font"));
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.gridy = 4;
        gridBagConstraints6.gridwidth = 2;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.anchor = 17;
        gridBagConstraints6.fill = 2;
        gridBagConstraints6.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jSeparator, gridBagConstraints6);
        this.myRecursiveButton = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("checkbox.set.property.update.properties.recursively"));
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.gridy = 5;
        gridBagConstraints7.gridwidth = 2;
        gridBagConstraints7.weightx = 1.0;
        gridBagConstraints7.anchor = 17;
        gridBagConstraints7.fill = 2;
        gridBagConstraints7.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jCheckBox, gridBagConstraints7);
        jLabel.setLabelFor(jComboBox);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

