/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.idea.svn.history.SvnFileRevision;
import org.jetbrains.idea.svn.history.SvnMergeSourceDetails;

public class MergeSourceDetailsAction
extends AnAction
implements DumbAware {
    public void update(AnActionEvent e) {
        e.getPresentation().setIcon(this.getIcon());
        e.getPresentation().setText("Show merge sources details");
        e.getPresentation().setEnabled(this.enabled(e));
    }

    private Icon getIcon() {
        return IconHolder.myIcon;
    }

    public void registerSelf(JComponent comp) {
        this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(77, 10)), comp);
    }

    private boolean enabled(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        if (project == null) {
            return false;
        }
        VirtualFile revisionVirtualFile = (VirtualFile)e.getData(VcsDataKeys.VCS_VIRTUAL_FILE);
        if (revisionVirtualFile == null) {
            return false;
        }
        VcsFileRevision revision = (VcsFileRevision)e.getData(VcsDataKeys.VCS_FILE_REVISION);
        if (revision == null) {
            return false;
        }
        if (!(revision instanceof SvnFileRevision)) {
            return false;
        }
        return !((SvnFileRevision)revision).getMergeSources().isEmpty();
    }

    public void actionPerformed(AnActionEvent e) {
        if (!this.enabled(e)) {
            return;
        }
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        VcsFileRevision revision = (VcsFileRevision)e.getData(VcsDataKeys.VCS_FILE_REVISION);
        VirtualFile revisionVirtualFile = (VirtualFile)e.getData(VcsDataKeys.VCS_VIRTUAL_FILE);
        SvnMergeSourceDetails.showMe(project, (SvnFileRevision)revision, revisionVirtualFile);
    }

    private static class IconHolder {
        private static final Icon myIcon = IconLoader.getIcon((String)"/icons/mergeSourcesDetails.png");

        private IconHolder() {
        }
    }
}

