/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.NotNullFunction;
import java.io.File;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.history.LocationDetector;

public class SvnRepositoryLocation
implements RepositoryLocation {
    private final String myURL;

    public SvnRepositoryLocation(String URL2) {
        this.myURL = URL2;
    }

    public String toString() {
        return this.myURL;
    }

    public String toPresentableString() {
        return this.myURL;
    }

    public String getURL() {
        return this.myURL;
    }

    public String getKey() {
        return this.myURL;
    }

    public void onBeforeBatch() throws VcsException {
    }

    public void onAfterBatch() {
    }

    @Nullable
    public static FilePath getLocalPath(String fullPath, NotNullFunction<File, Boolean> detector, SvnVcs vcs) {
        RootUrlInfo rootForUrl = vcs.getSvnFileUrlMapping().getWcRootForUrl(fullPath);
        if (rootForUrl != null) {
            return LocationDetector.filePathByUrlAndPath(fullPath, rootForUrl.getUrl().toString(), rootForUrl.getIoFile().getAbsolutePath(), detector);
        }
        return null;
    }
}

