/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.inspections;

import com.intellij.openapi.util.TextRange;
import com.intellij.spellchecker.inspections.BaseSplitter;
import com.intellij.spellchecker.inspections.CheckArea;
import com.intellij.spellchecker.util.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdentifierSplitter
extends BaseSplitter {
    @NonNls
    private static final Pattern WORD = Pattern.compile("\\b\\p{L}*'?\\p{L}*");
    @NonNls
    private static final Pattern WORD_IN_QUOTES = Pattern.compile("'([^']*)'");

    @Override
    @Nullable
    public List<CheckArea> split(@Nullable String text, @NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/spellchecker/inspections/IdentifierSplitter.split must not be null");
        }
        if (text == null || range.getLength() < 1) {
            return null;
        }
        List<TextRange> extracted = IdentifierSplitter.excludeByPattern(text, range, WORD_IN_QUOTES, 1);
        if (extracted == null) {
            return null;
        }
        ArrayList<CheckArea> results = new ArrayList<CheckArea>();
        for (TextRange textRange : extracted) {
            List<TextRange> words = IdentifierSplitter.splitByCase(text, textRange);
            if (words == null || words.size() == 0) continue;
            if (words.size() == 1) {
                IdentifierSplitter.addWord(text, results, false, words.get(0));
                continue;
            }
            boolean isCapitalized = Strings.isCapitalized(text, words.get(0));
            boolean containsShortWord = IdentifierSplitter.containsShortWord(words);
            if (isCapitalized && containsShortWord) continue;
            boolean isAllWordsAreUpperCased = IdentifierSplitter.isAllWordsAreUpperCased(text, words);
            for (TextRange word : words) {
                boolean flag;
                boolean uc = Strings.isUpperCased(text, word);
                boolean bl = flag = uc && !isAllWordsAreUpperCased;
                Matcher matcher = WORD.matcher(text.substring(word.getStartOffset(), word.getEndOffset()));
                if (!matcher.find()) continue;
                TextRange found = IdentifierSplitter.matcherRange(word, matcher);
                IdentifierSplitter.addWord(text, results, flag, found);
            }
        }
        return results;
    }

    public static List<TextRange> splitByCase(@NotNull String text, @NotNull TextRange range) {
        int i;
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/inspections/IdentifierSplitter.splitByCase must not be null");
        }
        if (range == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/spellchecker/inspections/IdentifierSplitter.splitByCase must not be null");
        }
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        int s = -1;
        int prevType = 25;
        for (i = range.getStartOffset(); i < range.getEndOffset(); ++i) {
            char ch = text.charAt(i);
            int type = Character.getType(ch);
            if (type == 2 || type == 1 || type == 3 || type == 5 || type == 4 || type == 24) {
                if (s < 0) {
                    s = i;
                } else if (s >= 0 && type == 1 && prevType == 2) {
                    IdentifierSplitter.add(text, result, i, s);
                    s = i;
                } else if (i - s >= 1 && type == 2 && prevType == 1) {
                    IdentifierSplitter.add(text, result, i - 1, s);
                    s = i - 1;
                }
            } else if (s >= 0) {
                IdentifierSplitter.add(text, result, i, s);
                s = -1;
            }
            prevType = type;
        }
        if (s >= 0) {
            IdentifierSplitter.add(text, result, i, s);
        }
        return result;
    }

    private static void add(String text, List<TextRange> result, int i, int s) {
        if (i - s > 3) {
            TextRange textRange = new TextRange(s, i);
            result.add(textRange);
        }
    }
}

