/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.util;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReturnStatement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiUtil {
    private PsiUtil() {
    }

    public static boolean isInstanciatable(@NotNull PsiClass cls) {
        if (cls == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/devkit/util/PsiUtil.isInstanciatable must not be null");
        }
        PsiModifierList modifiers = cls.getModifierList();
        if (modifiers == null || cls.isInterface() || modifiers.hasModifierProperty("abstract") || !PsiUtil.isPublicOrStaticInnerClass(cls)) {
            return false;
        }
        PsiMethod[] constructors = cls.getConstructors();
        if (constructors.length == 0) {
            return true;
        }
        for (PsiMethod constructor : constructors) {
            if (constructor.getParameterList().getParameters().length != 0 || !constructor.hasModifierProperty("public")) continue;
            return true;
        }
        return false;
    }

    public static boolean isPublicOrStaticInnerClass(@NotNull PsiClass cls) {
        if (cls == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/devkit/util/PsiUtil.isPublicOrStaticInnerClass must not be null");
        }
        PsiModifierList modifiers = cls.getModifierList();
        if (modifiers == null) {
            return false;
        }
        return modifiers.hasModifierProperty("public") && (cls.getParent() instanceof PsiFile || modifiers.hasModifierProperty("static"));
    }

    public static boolean isOneStatementMethod(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/devkit/util/PsiUtil.isOneStatementMethod must not be null");
        }
        PsiCodeBlock body = method.getBody();
        return body != null && body.getStatements().length == 1 && body.getStatements()[0] instanceof PsiReturnStatement;
    }

    @Nullable
    public static String getReturnedLiteral(PsiMethod method, PsiClass cls) {
        if (PsiUtil.isOneStatementMethod(method)) {
            PsiExpression value = ((PsiReturnStatement)method.getBody().getStatements()[0]).getReturnValue();
            if (value instanceof PsiLiteralExpression) {
                Object str = ((PsiLiteralExpression)value).getValue();
                return str == null ? null : str.toString();
            }
            if (value instanceof PsiMethodCallExpression && PsiUtil.isSimpleClassNameExpression((PsiMethodCallExpression)value)) {
                return cls.getName();
            }
        }
        return null;
    }

    private static boolean isSimpleClassNameExpression(PsiMethodCallExpression expr) {
        String text = expr.getText();
        if (text == null) {
            return false;
        }
        return "getClass().getSimpleName()".equals(text = text.replaceAll(" ", "").replaceAll("\n", "").replaceAll("\t", "").replaceAll("\r", "")) || "this.getClass().getSimpleName()".equals(text);
    }

    @Nullable
    public static PsiExpression getReturnedExpression(PsiMethod method) {
        if (PsiUtil.isOneStatementMethod(method)) {
            return ((PsiReturnStatement)method.getBody().getStatements()[0]).getReturnValue();
        }
        return null;
    }
}

