/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.Cvs2Configurable;
import com.intellij.cvsSupport2.CvsDiffProvider;
import com.intellij.cvsSupport2.CvsRevisionSelector;
import com.intellij.cvsSupport2.CvsStandardOperationsProvider;
import com.intellij.cvsSupport2.CvsStatusEnvironment;
import com.intellij.cvsSupport2.CvsUpdateEnvironment;
import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.actions.merge.CvsMergeProvider;
import com.intellij.cvsSupport2.annotate.CvsAnnotationProvider;
import com.intellij.cvsSupport2.annotate.CvsFileAnnotation;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.application.CvsStorageComponent;
import com.intellij.cvsSupport2.changeBrowser.CvsCommittedChangesProvider;
import com.intellij.cvsSupport2.checkinProject.CvsCheckinEnvironment;
import com.intellij.cvsSupport2.checkinProject.CvsRollbackEnvironment;
import com.intellij.cvsSupport2.checkout.CvsCheckoutProvider;
import com.intellij.cvsSupport2.config.CvsConfiguration;
import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutor;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutorCallback;
import com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler;
import com.intellij.cvsSupport2.cvshandlers.CvsHandler;
import com.intellij.cvsSupport2.cvsoperations.common.CvsOperation;
import com.intellij.cvsSupport2.cvsoperations.common.FindAllRootsHelper;
import com.intellij.cvsSupport2.cvsoperations.cvsAnnotate.AnnotateOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsAnnotate.Annotation;
import com.intellij.cvsSupport2.cvsoperations.cvsEdit.ui.EditOptionsDialog;
import com.intellij.cvsSupport2.cvsstatuses.CvsChangeProvider;
import com.intellij.cvsSupport2.cvsstatuses.CvsEntriesListener;
import com.intellij.cvsSupport2.history.CvsHistoryProvider;
import com.intellij.cvsSupport2.history.CvsRevisionNumber;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.cvsIntegration.CvsResult;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.EditFileProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.TransactionProvider;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.VcsShowSettingOption;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.RevisionSelector;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CvsVcs2
extends AbstractVcs
implements TransactionProvider,
EditFileProvider,
CvsEntriesListener {
    private static final String NAME = "CVS";
    private static final VcsKey ourKey = CvsVcs2.createKey((String)"CVS");
    private final Cvs2Configurable myConfigurable;
    @NonNls
    private static final String ourRevisionPattern = "\\d+(\\.\\d+)*";
    private CvsStorageComponent myStorageComponent = CvsStorageComponent.ABSENT_STORAGE;
    private final CvsHistoryProvider myCvsHistoryProvider;
    private final CvsCheckinEnvironment myCvsCheckinEnvironment;
    private final CvsCheckoutProvider myCvsCheckoutProvider;
    private RollbackEnvironment myCvsRollbackEnvironment;
    private final CvsStandardOperationsProvider myCvsStandardOperationsProvider;
    private final CvsUpdateEnvironment myCvsUpdateEnvironment;
    private final CvsStatusEnvironment myCvsStatusEnvironment;
    private final CvsAnnotationProvider myCvsAnnotationProvider;
    private final CvsDiffProvider myDiffProvider;
    private final CvsCommittedChangesProvider myCommittedChangesProvider;
    private final VcsShowSettingOption myAddOptions;
    private final VcsShowSettingOption myRemoveOptions;
    private final VcsShowSettingOption myCheckoutOptions;
    private final VcsShowSettingOption myEditOption;
    private final VcsShowConfirmationOption myAddConfirmation;
    private final VcsShowConfirmationOption myRemoveConfirmation;
    private ChangeProvider myChangeProvider;
    private MergeProvider myMergeProvider;

    public CvsVcs2(Project project, CvsStorageComponent cvsStorageComponent) {
        super(project, NAME);
        this.myCvsHistoryProvider = new CvsHistoryProvider(project);
        this.myCvsCheckinEnvironment = new CvsCheckinEnvironment(this.getProject());
        this.myCvsCheckoutProvider = new CvsCheckoutProvider();
        this.myCvsStandardOperationsProvider = new CvsStandardOperationsProvider(project);
        this.myCvsUpdateEnvironment = new CvsUpdateEnvironment(project);
        this.myCvsStatusEnvironment = new CvsStatusEnvironment(this.myProject);
        this.myConfigurable = new Cvs2Configurable(this.getProject());
        this.myStorageComponent = cvsStorageComponent;
        this.myCvsAnnotationProvider = new CvsAnnotationProvider(this.myProject);
        this.myDiffProvider = new CvsDiffProvider(this.myProject);
        this.myCommittedChangesProvider = new CvsCommittedChangesProvider(this.myProject);
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        this.myAddOptions = vcsManager.getStandardOption(VcsConfiguration.StandardOption.ADD, (AbstractVcs)this);
        this.myRemoveOptions = vcsManager.getStandardOption(VcsConfiguration.StandardOption.ADD, (AbstractVcs)this);
        this.myCheckoutOptions = vcsManager.getStandardOption(VcsConfiguration.StandardOption.CHECKOUT, (AbstractVcs)this);
        this.myEditOption = vcsManager.getStandardOption(VcsConfiguration.StandardOption.EDIT, (AbstractVcs)this);
        this.myAddConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, (AbstractVcs)this);
        this.myRemoveConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.REMOVE, (AbstractVcs)this);
    }

    public String getDisplayName() {
        return CvsBundle.getCvsDisplayName();
    }

    public Configurable getConfigurable() {
        return this.myConfigurable;
    }

    public TransactionProvider getTransactionProvider() {
        return this;
    }

    public void startTransaction(Object parameters) throws VcsException {
        this.myCvsStandardOperationsProvider.createTransaction();
    }

    public void commitTransaction(Object parameters) throws VcsException {
        this.myCvsStandardOperationsProvider.commit(parameters);
    }

    public void rollbackTransaction(Object parameters) {
        this.myCvsStandardOperationsProvider.rollback();
    }

    public byte[] getFileContent(String path) throws VcsException {
        return this.myCvsStandardOperationsProvider.getFileContent(path);
    }

    public CvsStandardOperationsProvider getStandardOperationsProvider() {
        return this.myCvsStandardOperationsProvider;
    }

    public static CvsVcs2 getInstance(Project project) {
        return (CvsVcs2)ProjectLevelVcsManager.getInstance((Project)project).findVcsByName(NAME);
    }

    public int getFilesToProcessCount() {
        return this.myCvsStandardOperationsProvider.getFilesToProcessCount();
    }

    public static void executeOperation(String title, CvsOperation operation, Project project) throws VcsException {
        CvsOperationExecutor executor = new CvsOperationExecutor(project);
        executor.performActionSync(new CommandCvsHandler(title, operation), CvsOperationExecutorCallback.EMPTY);
        CvsResult result = executor.getResult();
        if (!result.hasNoErrors()) {
            throw result.composeError();
        }
    }

    public static CvsOperationExecutor executeQuietOperation(String title, CvsOperation operation, Project project) {
        CvsOperationExecutor executor = new CvsOperationExecutor(false, project, ModalityState.defaultModalityState());
        executor.setIsQuietOperation(true);
        executor.performActionSync(new CommandCvsHandler(title, operation), CvsOperationExecutorCallback.EMPTY);
        return executor;
    }

    public VcsShowSettingOption getAddOptions() {
        return this.myAddOptions;
    }

    public VcsShowSettingOption getRemoveOptions() {
        return this.myRemoveOptions;
    }

    public VcsShowSettingOption getCheckoutOptions() {
        return this.myCheckoutOptions;
    }

    public EditFileProvider getEditFileProvider() {
        return this;
    }

    public void editFiles(VirtualFile[] files) {
        if (this.getEditOptions().getValue()) {
            EditOptionsDialog editOptionsDialog = new EditOptionsDialog(this.myProject);
            editOptionsDialog.show();
            if (!editOptionsDialog.isOK()) {
                return;
            }
        }
        CvsHandler editHandler = CommandCvsHandler.createEditHandler(files, CvsConfiguration.getInstance((Project)this.myProject).RESERVED_EDIT);
        new CvsOperationExecutor(true, this.myProject, ModalityState.current()).performActionSync(editHandler, CvsOperationExecutorCallback.EMPTY);
    }

    public String getRequestText() {
        return CvsBundle.message((String)"message.text.edit.file.request", (Object[])new Object[0]);
    }

    public ChangeProvider getChangeProvider() {
        if (this.myChangeProvider == null) {
            this.myChangeProvider = new CvsChangeProvider(this, CvsEntriesManager.getInstance());
        }
        return this.myChangeProvider;
    }

    protected void activate() {
        this.myStorageComponent.init(this.getProject(), false);
        CvsEntriesManager.getInstance().addCvsEntriesListener(this);
    }

    protected void deactivate() {
        this.myStorageComponent.dispose();
        CvsEntriesManager.getInstance().removeCvsEntriesListener(this);
    }

    @Override
    public void entriesChanged(VirtualFile parent) {
        VirtualFile[] children = parent.getChildren();
        if (children == null) {
            return;
        }
        for (VirtualFile child : children) {
            this.fireFileStatusChanged(child);
        }
        VcsDirtyScopeManager.getInstance((Project)this.getProject()).fileDirty(parent);
    }

    @Override
    public void entryChanged(VirtualFile file) {
        this.fireFileStatusChanged(file);
        VcsDirtyScopeManager.getInstance((Project)this.getProject()).fileDirty(file);
    }

    private void fireFileStatusChanged(VirtualFile file) {
        FileStatusManager.getInstance((Project)this.getProject()).fileStatusChanged(file);
    }

    @NotNull
    public CheckinEnvironment getCheckinEnvironment() {
        CvsCheckinEnvironment cvsCheckinEnvironment = this.myCvsCheckinEnvironment;
        if (cvsCheckinEnvironment == null) {
            throw new IllegalStateException("@NotNull method com/intellij/cvsSupport2/CvsVcs2.getCheckinEnvironment must not return null");
        }
        return cvsCheckinEnvironment;
    }

    public RollbackEnvironment getRollbackEnvironment() {
        if (this.myCvsRollbackEnvironment == null) {
            this.myCvsRollbackEnvironment = new CvsRollbackEnvironment(this.myProject);
        }
        return this.myCvsRollbackEnvironment;
    }

    public VcsHistoryProvider getVcsBlockHistoryProvider() {
        return this.myCvsHistoryProvider;
    }

    @NotNull
    public VcsHistoryProvider getVcsHistoryProvider() {
        CvsHistoryProvider cvsHistoryProvider = this.myCvsHistoryProvider;
        if (cvsHistoryProvider == null) {
            throw new IllegalStateException("@NotNull method com/intellij/cvsSupport2/CvsVcs2.getVcsHistoryProvider must not return null");
        }
        return cvsHistoryProvider;
    }

    public String getMenuItemText() {
        return CvsBundle.message((String)"menu.text.cvsGroup", (Object[])new Object[0]);
    }

    public UpdateEnvironment getUpdateEnvironment() {
        return this.myCvsUpdateEnvironment;
    }

    public boolean fileIsUnderVcs(FilePath filePath) {
        return CvsUtil.fileIsUnderCvs(filePath.getIOFile());
    }

    public boolean fileExistsInVcs(FilePath path) {
        return CvsUtil.fileExistsInCvs(path);
    }

    public UpdateEnvironment getStatusEnvironment() {
        return this.myCvsStatusEnvironment;
    }

    public AnnotationProvider getAnnotationProvider() {
        return this.myCvsAnnotationProvider;
    }

    public FileAnnotation createAnnotation(VirtualFile cvsVirtualFile, String revision, CvsEnvironment environment) throws VcsException {
        boolean hasLocalFile = false;
        File cvsFile = new File(cvsVirtualFile.getPath());
        if (cvsFile.isAbsolute()) {
            hasLocalFile = true;
            cvsFile = new File(CvsUtil.getModuleName(cvsVirtualFile));
        }
        AnnotateOperation annotateOperation = new AnnotateOperation(cvsFile, revision, environment);
        CvsOperationExecutor executor = new CvsOperationExecutor(this.myProject);
        executor.performActionSync(new CommandCvsHandler(CvsBundle.getAnnotateOperationName(), annotateOperation), CvsOperationExecutorCallback.EMPTY);
        if (executor.getResult().hasNoErrors()) {
            ArrayList<VcsFileRevision> revisions;
            if (hasLocalFile) {
                CvsHistoryProvider historyProvider = (CvsHistoryProvider)this.getVcsHistoryProvider();
                FilePath filePath = VcsContextFactory.SERVICE.getInstance().createFilePathOn(cvsVirtualFile);
                revisions = historyProvider.createRevisions(filePath);
            } else {
                Annotation[] lineAnnotations = annotateOperation.getLineAnnotations();
                revisions = new ArrayList();
                HashSet<String> usedRevisions = new HashSet<String>();
                for (Annotation annotation : lineAnnotations) {
                    if (usedRevisions.contains(annotation.getRevision())) continue;
                    revisions.add(new RevisionPresentation(annotation.getRevision(), annotation.getUserName(), annotation.getDate()));
                    usedRevisions.add(annotation.getRevision());
                }
            }
            return new CvsFileAnnotation(annotateOperation.getContent(), annotateOperation.getLineAnnotations(), revisions, cvsVirtualFile);
        }
        throw executor.getResult().composeError();
    }

    public DiffProvider getDiffProvider() {
        return this.myDiffProvider;
    }

    public VcsShowSettingOption getEditOptions() {
        return this.myEditOption;
    }

    public VcsShowConfirmationOption getAddConfirmation() {
        return this.myAddConfirmation;
    }

    public VcsShowConfirmationOption getRemoveConfirmation() {
        return this.myRemoveConfirmation;
    }

    @Nullable
    public RevisionSelector getRevisionSelector() {
        return new CvsRevisionSelector(this.myProject);
    }

    public CommittedChangesProvider getCommittedChangesProvider() {
        return this.myCommittedChangesProvider;
    }

    @Nullable
    public VcsRevisionNumber parseRevisionNumber(String revisionNumberString) {
        return new CvsRevisionNumber(revisionNumberString);
    }

    public String getRevisionPattern() {
        return ourRevisionPattern;
    }

    public static String staticRevisionPattern() {
        return ourRevisionPattern;
    }

    public boolean isVersionedDirectory(VirtualFile dir) {
        VirtualFile child = dir.findChild(NAME);
        return child != null && child.isDirectory();
    }

    public CvsCheckoutProvider getCheckoutProvider() {
        return this.myCvsCheckoutProvider;
    }

    public AbstractVcs.RootsConvertor getCustomConvertor() {
        return new AbstractVcs.RootsConvertor(){

            public List<VirtualFile> convertRoots(List<VirtualFile> result) {
                return FindAllRootsHelper.findVersionedUnder(result);
            }
        };
    }

    public MergeProvider getMergeProvider() {
        if (this.myMergeProvider != null) {
            this.myMergeProvider = new CvsMergeProvider();
        }
        return this.myMergeProvider;
    }

    public static VcsKey getKey() {
        return ourKey;
    }

    private static class RevisionPresentation
    implements VcsFileRevision {
        private final VcsRevisionNumber myNumber;
        private final String myAuthor;
        private final Date myDate;

        private RevisionPresentation(String revision, String author, Date date) {
            this.myNumber = new CvsRevisionNumber(revision);
            this.myAuthor = author;
            this.myDate = date;
        }

        public VcsRevisionNumber getRevisionNumber() {
            return this.myNumber;
        }

        public String getBranchName() {
            return null;
        }

        public Date getRevisionDate() {
            return this.myDate;
        }

        public String getAuthor() {
            return this.myAuthor;
        }

        public String getCommitMessage() {
            return null;
        }

        public void loadContent() throws VcsException {
        }

        public byte[] getContent() throws IOException {
            return new byte[0];
        }
    }
}

