/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.checkinProject;

import com.intellij.cvsSupport2.checkinProject.CvsRollbacker;
import com.intellij.cvsSupport2.config.CvsConfiguration;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutor;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutorCallback;
import com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler;
import com.intellij.cvsSupport2.cvshandlers.CvsHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.rollback.DefaultRollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CvsRollbackEnvironment
extends DefaultRollbackEnvironment {
    private final Project myProject;

    public CvsRollbackEnvironment(Project project) {
        this.myProject = project;
    }

    public void rollbackChanges(List<Change> changes, List<VcsException> exceptions, @NotNull RollbackProgressListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/cvsSupport2/checkinProject/CvsRollbackEnvironment.rollbackChanges must not be null");
        }
        listener.determinate();
        CvsRollbacker rollbacker = new CvsRollbacker(this.myProject);
        for (Change change : changes) {
            FilePath filePath = ChangesUtil.getFilePath((Change)change);
            listener.accept(change);
            VirtualFile parent = filePath.getVirtualFileParent();
            String name = filePath.getName();
            try {
                switch (change.getType()) {
                    case DELETED: {
                        rollbacker.rollbackFileDeleting(parent, name);
                        break;
                    }
                    case MODIFICATION: {
                        rollbacker.rollbackFileModifying(parent, name);
                        break;
                    }
                    case MOVED: {
                        CvsRollbacker.rollbackFileCreating(parent, name);
                        break;
                    }
                    case NEW: {
                        CvsRollbacker.rollbackFileCreating(parent, name);
                    }
                }
            }
            catch (IOException e) {
                exceptions.add(new VcsException((Throwable)e));
            }
        }
    }

    public void rollbackMissingFileDeletion(List<FilePath> filePaths, List<VcsException> exceptions, RollbackProgressListener listener) {
        CvsHandler cvsHandler = CommandCvsHandler.createCheckoutFileHandler(filePaths.toArray(new FilePath[filePaths.size()]), CvsConfiguration.getInstance(this.myProject));
        CvsOperationExecutor executor = new CvsOperationExecutor(this.myProject);
        executor.performActionSync(cvsHandler, CvsOperationExecutorCallback.EMPTY);
    }
}

