/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections.ext.ui;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.config.CvsRootEditor;
import com.intellij.cvsSupport2.config.ExtConfiguration;
import com.intellij.cvsSupport2.config.SshSettings;
import com.intellij.cvsSupport2.connections.ext.ui.ExtConnectionSettingsPanel;
import com.intellij.cvsSupport2.connections.ssh.ui.SshConnectionSettingsPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;

public class ExtConnectionDualPanel {
    private final ExtConnectionSettingsPanel myExtSettingsPanel;
    private final SshConnectionSettingsPanel mySshSettingsPanel;
    private final JPanel myPanel = new JPanel(new BorderLayout());
    private final JPanel myDualPanel = new JPanel(new CardLayout());
    private final JCheckBox myUseInternalImplementationCheckBox = new JCheckBox(CvsBundle.message((String)"checkbox.text.use.internal.ssh.implementation", (Object[])new Object[0]));
    @NonNls
    private static final String EXT = "EXT";
    @NonNls
    private static final String SSH = "SSH";

    public ExtConnectionDualPanel(CvsRootEditor rootProvider) {
        this.myExtSettingsPanel = new ExtConnectionSettingsPanel();
        this.mySshSettingsPanel = new SshConnectionSettingsPanel(rootProvider);
        this.myDualPanel.add((Component)this.myExtSettingsPanel.getPanel(), EXT);
        this.myDualPanel.add((Component)this.mySshSettingsPanel.getPanel(), SSH);
        this.myPanel.add((Component)this.myUseInternalImplementationCheckBox, "North");
        this.myPanel.add((Component)this.myDualPanel, "Center");
        this.myUseInternalImplementationCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtConnectionDualPanel.this.updatePage();
            }
        });
    }

    private void updatePage() {
        CardLayout cardLayout = (CardLayout)this.myDualPanel.getLayout();
        if (this.myUseInternalImplementationCheckBox.isSelected()) {
            cardLayout.show(this.myDualPanel, SSH);
        } else {
            cardLayout.show(this.myDualPanel, EXT);
        }
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    public void updateFrom(ExtConfiguration extConfiguration, SshSettings sshSettings) {
        this.myExtSettingsPanel.updateFrom(extConfiguration);
        this.mySshSettingsPanel.updateFrom(sshSettings);
        this.myUseInternalImplementationCheckBox.setSelected(extConfiguration.USE_INTERNAL_SSH_IMPLEMENTATION);
        this.updatePage();
    }

    public boolean equalsTo(ExtConfiguration extConfiguration, SshSettings sshSettings) {
        if (!this.myExtSettingsPanel.equalsTo(extConfiguration)) {
            return false;
        }
        if (!this.mySshSettingsPanel.equalsTo(sshSettings)) {
            return false;
        }
        return this.myUseInternalImplementationCheckBox.isSelected() == extConfiguration.USE_INTERNAL_SSH_IMPLEMENTATION;
    }

    public void saveTo(ExtConfiguration extConfiguration, SshSettings sshSettings) {
        this.myExtSettingsPanel.saveTo(extConfiguration);
        this.mySshSettingsPanel.saveTo(sshSettings);
        extConfiguration.USE_INTERNAL_SSH_IMPLEMENTATION = this.myUseInternalImplementationCheckBox.isSelected();
    }
}

