/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections.login;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.connections.CvsConnectionSettings;
import com.intellij.cvsSupport2.connections.login.CvsLoginWorker;
import com.intellij.cvsSupport2.cvsExecution.ModalityContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vcs.changes.ui.ChangesViewBalloonProblemNotifier;
import com.intellij.util.ThreeState;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;

public abstract class CvsLoginWorkerImpl<T extends CvsConnectionSettings>
implements CvsLoginWorker {
    protected final Project myProject;
    protected final ModalityContext myExecutor;
    protected final T mySettings;

    protected CvsLoginWorkerImpl(Project project, T settings, ModalityContext executor) {
        this.myProject = project;
        this.mySettings = settings;
        this.myExecutor = executor;
    }

    protected abstract void silentLoginImpl(boolean var1) throws AuthenticationException;

    public abstract boolean promptForPassword();

    protected abstract void clearOldCredentials();

    public ThreeState silentLogin(boolean forceCheck) {
        if (((CvsConnectionSettings)((Object)this.mySettings)).isOffline()) {
            return ThreeState.NO;
        }
        try {
            this.silentLoginImpl(forceCheck);
        }
        catch (AuthenticationException e) {
            return this.reportException(e);
        }
        return ThreeState.YES;
    }

    public void goOffline() {
        ((CvsConnectionSettings)((Object)this.mySettings)).setOffline(true);
        ChangesViewBalloonProblemNotifier.showMe((Project)this.myProject, (String)CvsBundle.message((String)"set.offline.notification.text", (Object[])new Object[0]), (MessageType)MessageType.WARNING);
    }

    private ThreeState reportException(AuthenticationException e) {
        if (e.isSolveable()) {
            this.clearOldCredentials();
            return ThreeState.UNSURE;
        }
        Throwable cause = e.getCause();
        if (cause instanceof SocketTimeoutException) {
            CvsLoginWorkerImpl.showConnectionErrorMessage(this.myProject, CvsBundle.message((String)"error.message.timeout.error", (Object[])new Object[0]));
        } else if (cause instanceof UnknownHostException) {
            CvsLoginWorkerImpl.showConnectionErrorMessage(this.myProject, CvsBundle.message((String)"error.message.unknown.host", (Object[])new Object[]{((CvsConnectionSettings)((Object)this.mySettings)).HOST}));
        } else if (cause instanceof ConnectException || cause instanceof NoRouteToHostException) {
            CvsLoginWorkerImpl.showConnectionErrorMessage(this.myProject, CvsBundle.message((String)"error.message.connection.error", (Object[])new Object[]{((CvsConnectionSettings)((Object)this.mySettings)).HOST}));
        } else {
            String localizedMessage = e.getLocalizedMessage();
            localizedMessage = localizedMessage == null ? e.getMessage() : localizedMessage;
            localizedMessage = localizedMessage == null ? CvsBundle.message((String)"error.dialog.title.cannot.connect.to.cvs", (Object[])new Object[0]) : localizedMessage;
            CvsLoginWorkerImpl.showConnectionErrorMessage(this.myProject, localizedMessage);
        }
        return ThreeState.NO;
    }

    public static void showConnectionErrorMessage(Project project, String message) {
        ChangesViewBalloonProblemNotifier.showMe((Project)project, (String)message, (MessageType)MessageType.ERROR);
    }
}

