/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections.pserver;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.config.CvsApplicationLevelConfiguration;
import com.intellij.cvsSupport2.connections.login.CvsLoginWorker;
import com.intellij.cvsSupport2.connections.login.CvsLoginWorkerImpl;
import com.intellij.cvsSupport2.connections.pserver.PServerCvsSettings;
import com.intellij.cvsSupport2.connections.pserver.PServerLoginProvider;
import com.intellij.cvsSupport2.connections.ssh.SolveableAuthenticationException;
import com.intellij.cvsSupport2.cvsExecution.ModalityContext;
import com.intellij.cvsSupport2.javacvsImpl.io.ReadWriteStatistics;
import com.intellij.cvsSupport2.javacvsImpl.io.StreamLogger;
import com.intellij.cvsSupport2.util.CvsFileUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.PasswordPromptDialog;
import com.intellij.openapi.util.io.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.IConnection;
import org.netbeans.lib.cvsclient.connection.PServerPasswordScrambler;
import org.netbeans.lib.cvsclient.connection.UnknownUserException;
import org.netbeans.lib.cvsclient.io.IStreamLogger;

public class PServerLoginProviderImpl
extends PServerLoginProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.connections.pserver.PServerLoginProviderImpl");

    @Override
    @Nullable
    public String getScrambledPasswordForCvsRoot(String cvsroot) {
        return PServerLoginProviderImpl.getPassword(cvsroot);
    }

    @Nullable
    private static String requestForPassword(String cvsroot) {
        PasswordPromptDialog passwordDialog = new PasswordPromptDialog(CvsBundle.message((String)"propmt.text.enter.password.for.cvs.root", (Object[])new Object[]{cvsroot}), CvsBundle.message((String)"propmt.title.enter.password.for.cvs.root", (Object[])new Object[0]), null);
        passwordDialog.show();
        if (!passwordDialog.isOK()) {
            return null;
        }
        return PServerPasswordScrambler.getInstance().scramble(passwordDialog.getPassword());
    }

    @Override
    public CvsLoginWorker getLoginWorker(ModalityContext executor, Project project, PServerCvsSettings pServerCvsSettings) {
        return new MyLoginWorker(project, pServerCvsSettings, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<String> readConfigurationNotMatchedWith(String cvsRoot, File passFile) {
        FileInputStream input;
        try {
            input = new FileInputStream(passFile);
        }
        catch (FileNotFoundException e) {
            return new ArrayList<String>();
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        ArrayList<String> result = new ArrayList<String>();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.indexOf(cvsRoot) != -1) continue;
                result.add(line);
            }
        }
        catch (IOException ex) {
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {}
        }
        return result;
    }

    private static void removeAllPasswordsForThisCvsRootFromPasswordFile(String cvsRoot) {
        File passFile = PServerLoginProviderImpl.getPassFile();
        if (passFile == null) {
            return;
        }
        if (!passFile.isFile()) {
            return;
        }
        ArrayList<String> lines = PServerLoginProviderImpl.readConfigurationNotMatchedWith(cvsRoot, passFile);
        try {
            CvsFileUtil.storeLines(lines, passFile);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void storePassword(String stringConfiguration, String scrambledPassword) throws IOException {
        File passFile = PServerLoginProviderImpl.getPassFile();
        FileUtil.createIfDoesntExist((File)passFile);
        List<String> lines = CvsFileUtil.readLinesFrom(passFile);
        lines.add(stringConfiguration + " " + scrambledPassword);
        CvsFileUtil.storeLines(lines, passFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String getPassword(String config) {
        String string;
        File passFile = PServerLoginProviderImpl.getPassFile();
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(passFile)));
        try {
            string = PServerLoginProviderImpl.findPasswordIn(reader, config);
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        reader.close();
        return string;
    }

    private static File getPassFile() {
        return new File(CvsApplicationLevelConfiguration.getInstance().getPathToPassFile());
    }

    @Nullable
    private static String findPasswordIn(BufferedReader reader, String config) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            int position = line.indexOf(config);
            if (position == -1) continue;
            String result = line.substring(position + config.length());
            return result.substring(1);
        }
        return null;
    }

    private static class MyLoginWorker
    extends CvsLoginWorkerImpl<PServerCvsSettings> {
        private MyLoginWorker(Project project, PServerCvsSettings settings, ModalityContext executor) {
            super(project, settings, executor);
        }

        @Override
        protected void silentLoginImpl(boolean forceCheck) throws AuthenticationException {
            String cvsRoot = ((PServerCvsSettings)this.mySettings).getCvsRootAsString();
            String stored = PServerLoginProviderImpl.getPassword(cvsRoot);
            if (stored == null) {
                throw new SolveableAuthenticationException(null);
            }
            if (forceCheck) {
                this.tryConnection();
            }
        }

        private void tryConnection() throws AuthenticationException {
            IConnection connection = ((PServerCvsSettings)this.mySettings).createConnection(new ReadWriteStatistics());
            try {
                connection.open((IStreamLogger)new StreamLogger());
                ((PServerCvsSettings)this.mySettings).setOffline(false);
            }
            catch (AuthenticationException e) {
                if (e instanceof UnknownUserException) {
                    throw new SolveableAuthenticationException(e.getMessage(), (Throwable)e);
                }
                throw e;
            }
            finally {
                try {
                    connection.close();
                }
                catch (IOException e) {}
            }
        }

        @Override
        public boolean promptForPassword() {
            String cvsRoot = ((PServerCvsSettings)this.mySettings).getCvsRootAsString();
            String password = PServerLoginProviderImpl.requestForPassword(cvsRoot);
            if (password == null) {
                return false;
            }
            PServerLoginProviderImpl.removeAllPasswordsForThisCvsRootFromPasswordFile(cvsRoot);
            try {
                PServerLoginProviderImpl.storePassword(cvsRoot, password);
            }
            catch (IOException e) {
                MyLoginWorker.showConnectionErrorMessage(this.myProject, CvsBundle.message((String)"error.message.cannot.store.password", (Object[])new Object[]{e.getLocalizedMessage()}));
                return false;
            }
            ((PServerCvsSettings)this.mySettings).storePassword(password);
            return true;
        }

        @Override
        protected void clearOldCredentials() {
            ((PServerCvsSettings)this.mySettings).releasePassword();
        }
    }
}

