/*
 * Decompiled with CFR 0.152.
 */
package org.gradle;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gradle.ParentLastClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BootstrapLoader {
    private URLClassLoader libClassLoader;

    public void initialize(File gradleHome, boolean bootStrapDebug) throws Exception {
        this.initialize(ClassLoader.getSystemClassLoader().getParent(), gradleHome, false, true, bootStrapDebug);
    }

    public void initialize(ClassLoader parentClassloader, File gradleHome, boolean useParentLastClassLoader, boolean loadOpenAPI, boolean bootStrapDebug) throws Exception {
        if (gradleHome == null || !gradleHome.exists()) {
            throw new RuntimeException("Gradle home not defined!");
        }
        if (bootStrapDebug) {
            System.out.println("Gradle Home is declared by system property gradle.home to: " + gradleHome.getAbsolutePath());
        }
        System.setProperty("gradle.home", gradleHome.getAbsolutePath());
        List<URL> loggingJars = BootstrapLoader.toUrl(BootstrapLoader.getLoggingJars());
        List<File> nonLoggingJarFiles = BootstrapLoader.getNonLoggingJars();
        this.removeUnwantedJarFiles(nonLoggingJarFiles, loadOpenAPI);
        List<URL> nonLoggingJars = BootstrapLoader.toUrl(nonLoggingJarFiles);
        if (bootStrapDebug) {
            System.out.println("Parent Classloader of new context classloader is: " + parentClassloader);
            System.out.println("Adding the following files to new logging classloader: " + loggingJars);
            System.out.println("Adding the following files to new lib classloader: " + nonLoggingJars);
        }
        URLClassLoader loggingClassLoader = new URLClassLoader(loggingJars.toArray(new URL[loggingJars.size()]), parentClassloader);
        this.libClassLoader = useParentLastClassLoader ? new ParentLastClassLoader(nonLoggingJars.toArray(new URL[nonLoggingJars.size()]), (ClassLoader)loggingClassLoader) : new URLClassLoader(nonLoggingJars.toArray(new URL[nonLoggingJars.size()]), (ClassLoader)loggingClassLoader);
        if (bootStrapDebug) {
            System.out.println("Logging class loader: " + loggingClassLoader);
            System.out.println("Lib class loader: " + this.libClassLoader);
        }
    }

    public static File[] getGradleHomeLibClasspath() {
        File gradleHomeLib = new File(System.getProperty("gradle.home") + "/lib");
        if (gradleHomeLib.isDirectory()) {
            return gradleHomeLib.listFiles();
        }
        return new File[0];
    }

    public static List<File> getNonLoggingJars() {
        ArrayList<File> pathElements = new ArrayList<File>();
        for (File file : BootstrapLoader.getGradleClasspath()) {
            if (BootstrapLoader.isLogLib(file)) continue;
            pathElements.add(file);
        }
        return pathElements;
    }

    public static List<File> getLoggingJars() {
        ArrayList<File> pathElements = new ArrayList<File>();
        for (File file : BootstrapLoader.getGradleClasspath()) {
            if (!BootstrapLoader.isLogLib(file)) continue;
            pathElements.add(file);
        }
        return pathElements;
    }

    private static boolean isLogLib(File file) {
        return file.getName().startsWith("logback") || file.getName().startsWith("slf4j");
    }

    public static List<File> getGradleClasspath() {
        File customGradleBin = null;
        ArrayList<File> pathElements = new ArrayList<File>();
        if (System.getProperty("gradle.bootstrap.gradleBin") != null) {
            customGradleBin = new File(System.getProperty("gradle.bootstrap.gradleBin"));
            pathElements.add(customGradleBin);
        }
        for (File homeLibFile : BootstrapLoader.getGradleHomeLibClasspath()) {
            if (!homeLibFile.isFile() || customGradleBin != null && homeLibFile.getName().startsWith("gradle-")) continue;
            pathElements.add(homeLibFile);
        }
        return pathElements;
    }

    private void removeUnwantedJarFiles(List<File> nonLoggingJarFiles, boolean loadOpenAPI) {
        if (loadOpenAPI) {
            return;
        }
        Iterator<File> iterator = nonLoggingJarFiles.iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            if (!file.getName().startsWith("gradle-open-api-")) continue;
            iterator.remove();
        }
    }

    public URLClassLoader getClassLoader() {
        return this.libClassLoader;
    }

    public Class load(String classPath) throws Exception {
        return this.libClassLoader.loadClass(classPath);
    }

    private static List<URL> toUrl(List<File> files) throws MalformedURLException {
        ArrayList<URL> result = new ArrayList<URL>();
        for (File file : files) {
            result.add(file.toURI().toURL());
        }
        return result;
    }
}

