/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.openapi.external.runner;

import java.io.File;
import java.lang.reflect.Constructor;
import org.gradle.openapi.external.ExternalUtility;
import org.gradle.openapi.external.runner.GradleRunnerInteractionVersion1;
import org.gradle.openapi.external.runner.GradleRunnerVersion1;

public class GradleRunnerFactory {
    public static GradleRunnerVersion1 createGradleRunner(ClassLoader parentClassLoader, File gradleHomeDirectory, GradleRunnerInteractionVersion1 interaction, boolean showDebugInfo) throws Exception {
        ClassLoader bootStrapClassLoader = ExternalUtility.getGradleClassloader(parentClassLoader, gradleHomeDirectory, showDebugInfo);
        Thread.currentThread().setContextClassLoader(bootStrapClassLoader);
        Class<?> soughtClass = null;
        try {
            soughtClass = bootStrapClassLoader.loadClass("org.gradle.openapi.wrappers.runner.GradleRunnerWrapper");
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
            return null;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        if (soughtClass == null) {
            return null;
        }
        Constructor<?> constructor = null;
        try {
            constructor = soughtClass.getDeclaredConstructor(File.class, GradleRunnerInteractionVersion1.class);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            System.out.println("Dumping available constructors on " + soughtClass.getName() + "\n" + ExternalUtility.dumpConstructors(soughtClass));
            throw e;
        }
        Object gradleRunner = constructor.newInstance(gradleHomeDirectory, interaction);
        return (GradleRunnerVersion1)gradleRunner;
    }
}

