/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.booleanIsAlwaysInverted;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.GlobalJavaInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.JavaRefactoringActionHandlerFactory;
import com.intellij.refactoring.RefactoringActionHandler;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BooleanMethodIsAlwaysInvertedInspection
extends GlobalJavaInspectionTool {
    private static final Key<Boolean> ALWAYS_INVERTED = Key.create((String)"ALWAYS_INVERTED_METHOD");

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"boolean.method.is.always.inverted.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/booleanIsAlwaysInverted/BooleanMethodIsAlwaysInvertedInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        if ("" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/booleanIsAlwaysInverted/BooleanMethodIsAlwaysInvertedInspection.getGroupDisplayName must not return null");
        }
        return "";
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("BooleanMethodIsAlwaysInverted" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/booleanIsAlwaysInverted/BooleanMethodIsAlwaysInvertedInspection.getShortName must not return null");
        }
        return "BooleanMethodIsAlwaysInverted";
    }

    @Nullable
    public RefGraphAnnotator getAnnotator(RefManager refManager) {
        return new BooleanInvertedAnnotator();
    }

    public CommonProblemDescriptor[] checkElement(RefEntity refEntity, AnalysisScope scope, InspectionManager manager, GlobalInspectionContext globalContext) {
        if (refEntity instanceof RefMethod) {
            RefMethod refMethod = (RefMethod)refEntity;
            if (!refMethod.isReferenced()) {
                return null;
            }
            if (BooleanMethodIsAlwaysInvertedInspection.hasNonInvertedCalls(refMethod)) {
                return null;
            }
            if (refMethod.getSuperMethods().size() > 0) {
                return null;
            }
            PsiMethod psiMethod = (PsiMethod)refMethod.getElement();
            PsiIdentifier psiIdentifier = psiMethod.getNameIdentifier();
            if (psiIdentifier != null) {
                return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)psiIdentifier, InspectionsBundle.message((String)"boolean.method.is.always.inverted.problem.descriptor", (Object[])new Object[0]), (LocalQuickFix)new InvertMethodFix(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false)};
            }
        }
        return null;
    }

    private static boolean hasNonInvertedCalls(RefMethod refMethod) {
        Boolean alwaysInverted = (Boolean)refMethod.getUserData(ALWAYS_INVERTED);
        if (alwaysInverted == null) {
            return true;
        }
        if (refMethod.isExternalOverride()) {
            return true;
        }
        if (refMethod.isReferenced() && !alwaysInverted.booleanValue()) {
            return true;
        }
        Collection superMethods = refMethod.getSuperMethods();
        for (RefMethod superMethod : superMethods) {
            if (!BooleanMethodIsAlwaysInvertedInspection.hasNonInvertedCalls(superMethod)) continue;
            return true;
        }
        return false;
    }

    protected boolean queryExternalUsagesRequests(RefManager manager, final GlobalJavaInspectionContext context, final ProblemDescriptionsProcessor descriptionsProcessor) {
        manager.iterate((RefVisitor)new RefJavaVisitor(){

            public void visitMethod(final RefMethod refMethod) {
                if (descriptionsProcessor.getDescriptions((RefEntity)refMethod) != null) {
                    GlobalJavaInspectionContext.UsagesProcessor usagesProcessor = new GlobalJavaInspectionContext.UsagesProcessor(){

                        public boolean process(PsiReference psiReference) {
                            PsiElement psiReferenceExpression = psiReference.getElement();
                            if (psiReferenceExpression instanceof PsiReferenceExpression && !BooleanMethodIsAlwaysInvertedInspection.isInvertedMethodCall((PsiReferenceExpression)psiReferenceExpression)) {
                                descriptionsProcessor.ignoreElement((RefEntity)refMethod);
                            }
                            return false;
                        }
                    };
                    BooleanMethodIsAlwaysInvertedInspection.traverseSuperMethods(refMethod, context, usagesProcessor);
                }
            }
        });
        return false;
    }

    private static void traverseSuperMethods(RefMethod refMethod, GlobalJavaInspectionContext globalContext, GlobalJavaInspectionContext.UsagesProcessor processor) {
        Collection superMethods = refMethod.getSuperMethods();
        for (RefMethod superMethod : superMethods) {
            BooleanMethodIsAlwaysInvertedInspection.traverseSuperMethods(superMethod, globalContext, processor);
        }
        globalContext.enqueueMethodUsagesProcessor(refMethod, processor);
    }

    private static void checkMethodCall(RefElement refWhat, PsiElement element) {
        if (!(refWhat instanceof RefMethod)) {
            return;
        }
        final RefMethod refMethod = (RefMethod)refWhat;
        PsiModifierListOwner psiElement = refMethod.getElement();
        if (!(psiElement instanceof PsiMethod)) {
            return;
        }
        final PsiMethod psiMethod = (PsiMethod)psiElement;
        if (!PsiType.BOOLEAN.equals(psiMethod.getReturnType())) {
            return;
        }
        element.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                super.visitMethodCallExpression(call);
                PsiReferenceExpression methodExpression = call.getMethodExpression();
                if (methodExpression.isReferenceTo((PsiElement)psiMethod)) {
                    if (BooleanMethodIsAlwaysInvertedInspection.isInvertedMethodCall(methodExpression)) {
                        return;
                    }
                    refMethod.putUserData(ALWAYS_INVERTED, (Object)Boolean.FALSE);
                }
            }
        });
    }

    private static boolean isInvertedMethodCall(PsiReferenceExpression methodExpression) {
        PsiJavaToken sign;
        IElementType tokenType;
        PsiPrefixExpression prefixExpression = (PsiPrefixExpression)PsiTreeUtil.getParentOfType((PsiElement)methodExpression, PsiPrefixExpression.class);
        if (methodExpression.getQualifierExpression() instanceof PsiSuperExpression) {
            return true;
        }
        return prefixExpression != null && (tokenType = (sign = prefixExpression.getOperationSign()).getTokenType()).equals(JavaTokenType.EXCL);
    }

    public QuickFix getQuickFix(String hint) {
        return new InvertMethodFix();
    }

    private static class InvertMethodFix
    implements LocalQuickFix {
        private InvertMethodFix() {
        }

        @NotNull
        public String getName() {
            if ("Invert method" == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/booleanIsAlwaysInverted/BooleanMethodIsAlwaysInvertedInspection$InvertMethodFix.getName must not return null");
            }
            return "Invert method";
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/booleanIsAlwaysInverted/BooleanMethodIsAlwaysInvertedInspection$InvertMethodFix.getFamilyName must not return null");
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/booleanIsAlwaysInverted/BooleanMethodIsAlwaysInvertedInspection$InvertMethodFix.applyFix must not be null");
            }
            if (descriptor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/booleanIsAlwaysInverted/BooleanMethodIsAlwaysInvertedInspection$InvertMethodFix.applyFix must not be null");
            }
            PsiElement element = descriptor.getPsiElement();
            PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
            assert (psiMethod != null);
            RefactoringActionHandler invertBooleanHandler = JavaRefactoringActionHandlerFactory.getInstance().createInvertBooleanHandler();
            invertBooleanHandler.invoke(project, new PsiElement[]{psiMethod}, DataManager.getInstance().getDataContext());
        }
    }

    private static class BooleanInvertedAnnotator
    extends RefGraphAnnotator {
        private BooleanInvertedAnnotator() {
        }

        public void onInitialize(RefElement refElement) {
            if (refElement instanceof RefMethod) {
                PsiElement element = refElement.getElement();
                if (!(element instanceof PsiMethod)) {
                    return;
                }
                if (((PsiMethod)element).getReturnType() != PsiType.BOOLEAN) {
                    return;
                }
                refElement.putUserData(ALWAYS_INVERTED, (Object)Boolean.TRUE);
            }
        }

        public void onMarkReferenced(RefElement refWhat, RefElement refFrom, boolean referencedFromClassInitializer) {
            BooleanMethodIsAlwaysInvertedInspection.checkMethodCall(refWhat, refFrom.getElement());
        }
    }
}

