/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.GlobalJavaInspectionTool;
import com.siyeh.InspectionGadgetsBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class BaseGlobalInspection
extends GlobalJavaInspectionTool {
    private String shortName = null;
    @NonNls
    private static final String INSPECTION = "Inspection";

    @NotNull
    public String getShortName() {
        if (this.shortName == null) {
            Class<?> aClass = ((Object)((Object)this)).getClass();
            String name = aClass.getName();
            this.shortName = name.substring(name.lastIndexOf(46) + 1, name.length() - INSPECTION.length());
        }
        String string = this.shortName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/BaseGlobalInspection.getShortName must not return null");
        }
        return string;
    }

    private String getPropertyPrefixForInspection() {
        String shortName = this.getShortName();
        return BaseGlobalInspection.getPrefix(shortName);
    }

    public static String getPrefix(String shortName) {
        StringBuilder builder = new StringBuilder(shortName.length() + 10);
        builder.append(Character.toLowerCase(shortName.charAt(0)));
        for (int i = 1; i < shortName.length(); ++i) {
            char c = shortName.charAt(i);
            if (Character.isUpperCase(c)) {
                builder.append('.').append(Character.toLowerCase(c));
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    @NotNull
    public String getDisplayName() {
        String displayNameSuffix = ".display.name";
        String string = InspectionGadgetsBundle.message(this.getPropertyPrefixForInspection() + ".display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/BaseGlobalInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/BaseGlobalInspection.getDefaultLevel must not return null");
        }
        return highlightDisplayLevel;
    }

    public boolean isEnabledByDefault() {
        return false;
    }
}

