/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.IntroduceConstantFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class MagicNumberInspection
extends BaseInspection {
    public boolean m_ignoreInHashCode = true;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("magic.number.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/MagicNumberInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("magic.number.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/MagicNumberInspection.buildErrorString must not return null");
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("magic.number.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreInHashCode");
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new IntroduceConstantFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MagicNumberVisitor();
    }

    private class MagicNumberVisitor
    extends BaseInspectionVisitor {
        private MagicNumberVisitor() {
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
            PsiMethod containingMethod;
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/abstraction/MagicNumberInspection$MagicNumberVisitor.visitLiteralExpression must not be null");
            }
            super.visitLiteralExpression(expression);
            PsiType type = expression.getType();
            if (!ClassUtils.isPrimitiveNumericType(type)) {
                return;
            }
            if (PsiType.CHAR.equals(type)) {
                return;
            }
            if (this.isSpecialCaseLiteral(expression)) {
                return;
            }
            if (this.isDeclaredConstant(expression)) {
                return;
            }
            if (MagicNumberInspection.this.m_ignoreInHashCode && MethodUtils.isHashCode(containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class))) {
                return;
            }
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiPrefixExpression) {
                this.registerError(parent, new Object[0]);
            } else {
                this.registerError((PsiElement)expression, new Object[0]);
            }
        }

        private boolean isDeclaredConstant(PsiLiteralExpression expression) {
            PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiField.class);
            if (field == null) {
                return false;
            }
            if (!field.hasModifierProperty("static") || !field.hasModifierProperty("final")) {
                return false;
            }
            PsiExpression initializer = field.getInitializer();
            if (initializer == null) {
                return false;
            }
            PsiType type = initializer.getType();
            return ClassUtils.isImmutable(type);
        }

        private boolean isSpecialCaseLiteral(PsiLiteralExpression expression) {
            Object object = ExpressionUtils.computeConstantExpression((PsiExpression)expression);
            if (object instanceof Integer) {
                int i = (Integer)object;
                return i >= 0 && i <= 10 || i == 100 || i == 1000;
            }
            if (object instanceof Long) {
                long l = (Long)object;
                return l >= 0L && l <= 2L;
            }
            if (object instanceof Double) {
                double d = (Double)object;
                return d == 1.0 || d == 0.0;
            }
            if (object instanceof Float) {
                float f = ((Float)object).floatValue();
                return f == 1.0f || f == 0.0f;
            }
            return false;
        }
    }
}

