/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ResultSetIndexZeroInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("UseOfIndexZeroInJDBCResultSet" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/ResultSetIndexZeroInspection.getID must not return null");
        }
        return "UseOfIndexZeroInJDBCResultSet";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("use.0index.in.jdbc.resultset.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/ResultSetIndexZeroInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("use.0index.in.jdbc.resultset.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/ResultSetIndexZeroInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ResultSetIndexZeroVisitor();
    }

    private static class ResultSetIndexZeroVisitor
    extends BaseInspectionVisitor {
        private ResultSetIndexZeroVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/ResultSetIndexZeroInspection$ResultSetIndexZeroVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (methodName == null) {
                return;
            }
            if (!methodName.startsWith("get") && !methodName.startsWith("update")) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            PsiExpression argument = arguments[0];
            if (!TypeUtils.expressionHasType("int", argument)) {
                return;
            }
            if (!PsiUtil.isConstantExpression((PsiExpression)argument)) {
                return;
            }
            Integer val = (Integer)ConstantExpressionUtil.computeCastTo((PsiExpression)argument, (PsiType)PsiType.INT);
            if (val == null || val != 0) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.sql.ResultSet")) {
                return;
            }
            this.registerError((PsiElement)argument, new Object[0]);
        }
    }
}

