/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.MoveClassFix;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class InnerClassOnInterfaceInspection
extends BaseInspection {
    public boolean m_ignoreInnerInterfaces = false;

    @NotNull
    public String getID() {
        if ("InnerClassOfInterface" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classlayout/InnerClassOnInterfaceInspection.getID must not return null");
        }
        return "InnerClassOfInterface";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("inner.class.on.interface.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classlayout/InnerClassOnInterfaceInspection.getDisplayName must not return null");
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("inner.class.on.interface.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreInnerInterfaces");
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass parentInterface = (PsiClass)infos[0];
        String interfaceName = parentInterface.getName();
        String string = InspectionGadgetsBundle.message("inner.class.on.interface.problem.descriptor", interfaceName);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classlayout/InnerClassOnInterfaceInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new MoveClassFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InnerClassOnInterfaceVisitor();
    }

    private class InnerClassOnInterfaceVisitor
    extends BaseInspectionVisitor {
        private InnerClassOnInterfaceVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiClass[] innerClasses;
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/classlayout/InnerClassOnInterfaceInspection$InnerClassOnInterfaceVisitor.visitClass must not be null");
            }
            if (!aClass.isInterface() || aClass.isAnnotationType()) {
                return;
            }
            for (PsiClass innerClass : innerClasses = aClass.getInnerClasses()) {
                if (!this.isInnerClass(innerClass)) continue;
                this.registerClassError(innerClass, aClass);
            }
        }

        private boolean isInnerClass(PsiClass innerClass) {
            if (innerClass.isEnum()) {
                return false;
            }
            if (innerClass.isAnnotationType()) {
                return false;
            }
            if (innerClass instanceof PsiTypeParameter || innerClass instanceof PsiAnonymousClass) {
                return false;
            }
            return !innerClass.isInterface() || !InnerClassOnInterfaceInspection.this.m_ignoreInnerInterfaces;
        }
    }
}

