/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleIntegerFieldOptionsPanel;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SwitchUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SwitchStatementDensityInspection
extends BaseInspection {
    private static final int DEFAULT_DENSITY_LIMIT = 20;
    public int m_limit = 20;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("switch.statement.density.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/SwitchStatementDensityInspection.getDisplayName must not return null");
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleIntegerFieldOptionsPanel(InspectionGadgetsBundle.message("switch.statement.density.min.option", new Object[0]), (InspectionProfileEntry)this, "m_limit");
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Integer intDensity = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("switch.statement.density.problem.descriptor", intDensity);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/SwitchStatementDensityInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SwitchStatementWithTooFewBranchesVisitor();
    }

    private static class StatementCountVisitor
    extends JavaRecursiveElementVisitor {
        private int numStatements = 0;

        private StatementCountVisitor() {
        }

        public void visitStatement(@NotNull PsiStatement psiStatement) {
            if (psiStatement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/controlflow/SwitchStatementDensityInspection$StatementCountVisitor.visitStatement must not be null");
            }
            super.visitStatement(psiStatement);
            ++this.numStatements;
        }

        public int getNumStatements() {
            return this.numStatements;
        }
    }

    private class SwitchStatementWithTooFewBranchesVisitor
    extends BaseInspectionVisitor {
        private SwitchStatementWithTooFewBranchesVisitor() {
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/controlflow/SwitchStatementDensityInspection$SwitchStatementWithTooFewBranchesVisitor.visitSwitchStatement must not be null");
            }
            PsiCodeBlock body = statement.getBody();
            if (body == null) {
                return;
            }
            double density = this.calculateDensity(statement);
            int intDensity = (int)(density * 100.0);
            if (intDensity > SwitchStatementDensityInspection.this.m_limit) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, intDensity);
        }

        private double calculateDensity(PsiSwitchStatement statement) {
            PsiCodeBlock body = statement.getBody();
            if (body == null) {
                return -1.0;
            }
            int numBranches = SwitchUtils.calculateBranchCount(statement);
            StatementCountVisitor visitor = new StatementCountVisitor();
            body.accept((PsiElementVisitor)visitor);
            int numStatements = visitor.getNumStatements();
            return (double)numBranches / (double)numStatements;
        }
    }
}

