/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dependency;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.SingleIntegerFieldOptionsPanel;
import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.dependency.DependencyUtils;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ClassWithTooManyDependenciesInspection
extends BaseGlobalInspection {
    public int limit = 10;

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.DEPENDENCY_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/dependency/ClassWithTooManyDependenciesInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    public void runInspection(AnalysisScope scope, final InspectionManager inspectionManager, GlobalInspectionContext globalInspectionContext, final ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        RefManager refManager = globalInspectionContext.getRefManager();
        refManager.iterate((RefVisitor)new RefJavaVisitor(){

            public void visitClass(RefClass refClass) {
                super.visitClass(refClass);
                PsiClass aClass = refClass.getElement();
                if (ClassUtils.isInnerClass(aClass)) {
                    return;
                }
                Set<RefClass> dependencies = DependencyUtils.calculateDependenciesForClass(refClass);
                int numDependencies = dependencies.size();
                if (numDependencies <= ClassWithTooManyDependenciesInspection.this.limit) {
                    return;
                }
                String errorString = InspectionGadgetsBundle.message("class.with.too.many.dependencies.problem.descriptor", refClass.getName(), numDependencies, ClassWithTooManyDependenciesInspection.this.limit);
                CommonProblemDescriptor[] descriptors = new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(errorString, new QuickFix[0])};
                problemDescriptionsProcessor.addProblemElement((RefEntity)refClass, descriptors);
            }
        });
    }

    public JComponent createOptionsPanel() {
        return new SingleIntegerFieldOptionsPanel(InspectionGadgetsBundle.message("class.with.too.many.dependencies.max.option", new Object[0]), (InspectionProfileEntry)this, "limit");
    }
}

