/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import com.intellij.refactoring.RefactoringFactory;
import com.intellij.refactoring.RenameRefactoring;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RenameFix
extends InspectionGadgetsFix {
    private final String m_targetName;

    public RenameFix() {
        this.m_targetName = null;
    }

    public RenameFix(@NonNls String targetName) {
        this.m_targetName = targetName;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getName() {
        String string;
        if (this.m_targetName == null) {
            string = InspectionGadgetsBundle.message("rename.quickfix", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/fixes/RenameFix.getName must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("renameto.quickfix", this.m_targetName);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/fixes/RenameFix.getName must not return null");
    }

    @Override
    public void doFix(Project project, ProblemDescriptor descriptor) {
        PsiElement nameIdentifier = descriptor.getPsiElement();
        PsiElement elementToRename = nameIdentifier.getParent();
        if (this.m_targetName == null) {
            RefactoringActionHandlerFactory factory = RefactoringActionHandlerFactory.getInstance();
            RefactoringActionHandler renameHandler = factory.createRenameHandler();
            DataManager dataManager = DataManager.getInstance();
            DataContext dataContext = dataManager.getDataContext();
            renameHandler.invoke(project, new PsiElement[]{elementToRename}, dataContext);
        } else {
            RefactoringFactory factory = RefactoringFactory.getInstance((Project)project);
            RenameRefactoring renameRefactoring = factory.createRename(elementToRename, this.m_targetName);
            renameRefactoring.run();
        }
    }
}

