/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.inheritance.StaticInheritanceFix;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class StaticInheritanceInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("static.inheritance.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/inheritance/StaticInheritanceInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("static.inheritance.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/inheritance/StaticInheritanceInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new StaticInheritanceFix(false), new StaticInheritanceFix(true)};
        if (inspectionGadgetsFixArray == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/inheritance/StaticInheritanceInspection.buildFixes must not return null");
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StaticInheritanceVisitor();
    }

    private static class StaticInheritanceVisitor
    extends BaseInspectionVisitor {
        private StaticInheritanceVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiJavaCodeReferenceElement[] references;
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/inheritance/StaticInheritanceInspection$StaticInheritanceVisitor.visitClass must not be null");
            }
            PsiReferenceList implementsList = aClass.getImplementsList();
            if (implementsList == null) {
                return;
            }
            for (PsiJavaCodeReferenceElement reference : references = implementsList.getReferenceElements()) {
                PsiClass iface = (PsiClass)reference.resolve();
                if (iface == null || !StaticInheritanceVisitor.interfaceContainsOnlyConstants(iface, new HashSet<PsiClass>())) continue;
                this.registerError((PsiElement)reference, new Object[0]);
            }
        }

        private static boolean interfaceContainsOnlyConstants(PsiClass iface, Set<PsiClass> visitedIntefaces) {
            PsiClass[] parentInterfaces;
            if (!visitedIntefaces.add(iface)) {
                return true;
            }
            if (iface.getAllFields().length == 0) {
                return false;
            }
            if (iface.getMethods().length != 0) {
                return false;
            }
            for (PsiClass parentInterface : parentInterfaces = iface.getInterfaces()) {
                if (StaticInheritanceVisitor.interfaceContainsOnlyConstants(parentInterface, visitedIntefaces)) continue;
                return false;
            }
            return true;
        }
    }
}

