/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;

public class SetupIsPublicVoidNoArgInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("SetUpWithIncorrectSignature" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/SetupIsPublicVoidNoArgInspection.getID must not return null");
        }
        return "SetUpWithIncorrectSignature";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("setup.is.public.void.no.arg.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/SetupIsPublicVoidNoArgInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("setup.is.public.void.no.arg.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/SetupIsPublicVoidNoArgInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SetupIsPublicVoidNoArgVisitor();
    }

    private static class SetupIsPublicVoidNoArgVisitor
    extends BaseInspectionVisitor {
        private SetupIsPublicVoidNoArgVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/junit/SetupIsPublicVoidNoArgInspection$SetupIsPublicVoidNoArgVisitor.visitMethod must not be null");
            }
            String methodName = method.getName();
            if (!"setUp".equals(methodName)) {
                return;
            }
            PsiType returnType = method.getReturnType();
            if (returnType == null) {
                return;
            }
            PsiClass targetClass = method.getContainingClass();
            if (targetClass == null) {
                return;
            }
            if (!ClassUtils.isSubclass(targetClass, "junit.framework.TestCase")) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != 0) {
                this.registerMethodError(method, new Object[0]);
            } else if (!returnType.equals(PsiType.VOID)) {
                this.registerMethodError(method, new Object[0]);
            } else if (!method.hasModifierProperty("public") && !method.hasModifierProperty("protected")) {
                this.registerMethodError(method, new Object[0]);
            }
        }
    }
}

