/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;

public class StaticSuiteInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("SuiteNotDeclaredStatic" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/StaticSuiteInspection.getID must not return null");
        }
        return "SuiteNotDeclaredStatic";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("static.suite.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/StaticSuiteInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("static.suite.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/StaticSuiteInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StaticSuiteVisitor();
    }

    private static class StaticSuiteVisitor
    extends BaseInspectionVisitor {
        private StaticSuiteVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/junit/StaticSuiteInspection$StaticSuiteVisitor.visitMethod must not be null");
            }
            String methodName = method.getName();
            if (!"suite".equals(methodName)) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            if (!ClassUtils.isSubclass(aClass, "junit.framework.TestCase")) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != 0) {
                return;
            }
            if (method.hasModifierProperty("static")) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }
    }
}

