/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.logging;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoggerInitializedWithForeignClassInspection
extends BaseInspection {
    public String loggerClassName = "org.apache.log4j.Logger";
    public String loggerFactoryMethodName = "getLogger";

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("logger.initialized.with.foreign.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/logging/LoggerInitializedWithForeignClassInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("logger.initialized.with.foreign.class.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/logging/LoggerInitializedWithForeignClassInspection.buildErrorString must not return null");
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new Form().getContentPanel();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new LoggerInitializedWithForeignClassFix((String)infos[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LoggerInitializedWithForeignClassVisitor();
    }

    class Form {
        private JPanel contentPanel;
        private JTextField loggerClassNameTextField;
        private JTextField loggerFactoryMethodNameTextField;

        Form() {
            this.$$$setupUI$$$();
            this.loggerClassNameTextField.setText(LoggerInitializedWithForeignClassInspection.this.loggerClassName);
            DocumentListener listener = new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.textChanged();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.textChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.textChanged();
                }

                private void textChanged() {
                    LoggerInitializedWithForeignClassInspection.this.loggerClassName = Form.this.loggerClassNameTextField.getText();
                }
            };
            Document document = this.loggerClassNameTextField.getDocument();
            document.addDocumentListener(listener);
            this.loggerFactoryMethodNameTextField.setText(LoggerInitializedWithForeignClassInspection.this.loggerFactoryMethodName);
            DocumentListener factoryListener = new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.textChanged();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.textChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.textChanged();
                }

                private void textChanged() {
                    LoggerInitializedWithForeignClassInspection.this.loggerClassName = Form.this.loggerClassNameTextField.getText();
                }
            };
            Document factoryDocument = this.loggerFactoryMethodNameTextField.getDocument();
            factoryDocument.addDocumentListener(factoryListener);
        }

        public JComponent getContentPanel() {
            return this.contentPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JTextField jTextField;
            JTextField jTextField2;
            JPanel jPanel;
            this.contentPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(4, 4, 4, 4), 0, 4, false, false));
            JLabel jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/siyeh/InspectionGadgetsBundle").getString("logger.name.option"));
            jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.loggerClassNameTextField = jTextField2 = new JTextField();
            jPanel.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
            JLabel jLabel2 = new JLabel();
            this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("com/siyeh/InspectionGadgetsBundle").getString("logger.factory.method.name"));
            jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.loggerFactoryMethodNameTextField = jTextField = new JTextField();
            jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
            jLabel.setLabelFor(jTextField2);
            jLabel2.setLabelFor(jTextField);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.contentPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }
    }

    private class LoggerInitializedWithForeignClassVisitor
    extends BaseInspectionVisitor {
        private LoggerInitializedWithForeignClassVisitor() {
        }

        public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression) {
            super.visitClassObjectAccessExpression(expression);
            PsiElement parent = expression.getParent();
            if (!(parent instanceof PsiExpressionList)) {
                return;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClass.class);
            if (containingClass == null) {
                return;
            }
            String containingClassName = containingClass.getName();
            if (containingClassName == null) {
                return;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!LoggerInitializedWithForeignClassInspection.this.loggerFactoryMethodName.equals(referenceName)) {
                return;
            }
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            String className = aClass.getQualifiedName();
            if (!LoggerInitializedWithForeignClassInspection.this.loggerClassName.equals(className)) {
                return;
            }
            PsiTypeElement operand = expression.getOperand();
            PsiType type = operand.getType();
            if (!(type instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)type;
            PsiClass initializerClass = classType.resolve();
            if (initializerClass == null) {
                return;
            }
            if (containingClass.equals(initializerClass)) {
                return;
            }
            this.registerError((PsiElement)expression, containingClassName);
        }
    }

    private static class LoggerInitializedWithForeignClassFix
    extends InspectionGadgetsFix {
        private final String newClassName;

        private LoggerInitializedWithForeignClassFix(String newClassName) {
            this.newClassName = newClassName;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("logger.initialized.with.foreign.class.quickfix", this.newClassName);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/logging/LoggerInitializedWithForeignClassInspection$LoggerInitializedWithForeignClassFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiClassObjectAccessExpression)) {
                return;
            }
            PsiClassObjectAccessExpression classObjectAccessExpression = (PsiClassObjectAccessExpression)element;
            LoggerInitializedWithForeignClassFix.replaceExpression((PsiExpression)classObjectAccessExpression, this.newClassName + ".class");
        }
    }
}

