/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class OverloadedVarargsMethodInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("overloaded.vararg.method.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/OverloadedVarargsMethodInspection.getDisplayName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string;
        PsiMethod element = (PsiMethod)infos[0];
        if (element.isConstructor()) {
            string = InspectionGadgetsBundle.message("overloaded.vararg.constructor.problem.descriptor", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/OverloadedVarargsMethodInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("overloaded.vararg.method.problem.descriptor", new Object[0]);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/OverloadedVarargsMethodInspection.buildErrorString must not return null");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OverloadedVarargMethodVisitor();
    }

    private static class OverloadedVarargMethodVisitor
    extends BaseInspectionVisitor {
        private OverloadedVarargMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiMethod[] sameNameMethods;
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/naming/OverloadedVarargsMethodInspection$OverloadedVarargMethodVisitor.visitMethod must not be null");
            }
            if (!method.isVarArgs()) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            String methodName = method.getName();
            for (PsiMethod sameNameMethod : sameNameMethods = aClass.findMethodsByName(methodName, false)) {
                if (sameNameMethod.equals(method)) continue;
                this.registerMethodError(method, method);
            }
        }
    }
}

