/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.ui.DocumentAdapter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.RegExFormatter;
import com.siyeh.ig.RegExInputVerifier;
import com.siyeh.ig.ui.FormattedTextFieldMacFix;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.InternationalFormatter;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageNamingConventionInspection
extends BaseGlobalInspection {
    private static final int DEFAULT_MIN_LENGTH = 3;
    private static final int DEFAULT_MAX_LENGTH = 16;
    public String m_regex = "[a-z]*";
    public int m_minLength = 3;
    public int m_maxLength = 16;
    private Pattern m_regexPattern = Pattern.compile(this.m_regex);
    private static final int REGEX_COLUMN_COUNT = 25;

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.NAMING_CONVENTIONS_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/PackageNamingConventionInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(RefEntity refEntity, AnalysisScope analysisScope, InspectionManager inspectionManager, GlobalInspectionContext globalInspectionContext) {
        if (!(refEntity instanceof RefPackage)) {
            return null;
        }
        String name = refEntity.getName();
        if (name == null) {
            return null;
        }
        int length = name.length();
        if (length < this.m_minLength) {
            String errorString = InspectionGadgetsBundle.message("package.naming.convention.problem.descriptor.short", name);
            return new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(errorString, new QuickFix[0])};
        }
        if (length > this.m_maxLength) {
            String errorString = InspectionGadgetsBundle.message("package.naming.convention.problem.descriptor.long", name);
            return new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(errorString, new QuickFix[0])};
        }
        Matcher matcher = this.m_regexPattern.matcher(name);
        if (matcher.matches()) {
            return null;
        }
        String errorString = InspectionGadgetsBundle.message("package.naming.convention.problem.descriptor.regex.mismatch", name, this.m_regex);
        return new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(errorString, new QuickFix[0])};
    }

    public void readSettings(Element element) throws InvalidDataException {
        super.readSettings(element);
        this.m_regexPattern = Pattern.compile(this.m_regex);
    }

    public JComponent createOptionsPanel() {
        GridBagLayout layout = new GridBagLayout();
        JPanel panel = new JPanel(layout);
        JLabel patternLabel = new JLabel(InspectionGadgetsBundle.message("convention.pattern.option", new Object[0]));
        patternLabel.setHorizontalAlignment(11);
        JLabel minLengthLabel = new JLabel(InspectionGadgetsBundle.message("convention.min.length.option", new Object[0]));
        minLengthLabel.setHorizontalAlignment(11);
        JLabel maxLengthLabel = new JLabel(InspectionGadgetsBundle.message("convention.max.length.option", new Object[0]));
        maxLengthLabel.setHorizontalAlignment(11);
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        numberFormat.setParseIntegerOnly(true);
        numberFormat.setMinimumIntegerDigits(1);
        numberFormat.setMaximumIntegerDigits(2);
        InternationalFormatter formatter = new InternationalFormatter(numberFormat);
        formatter.setAllowsInvalid(false);
        formatter.setCommitsOnValidEdit(true);
        final JFormattedTextField minLengthField = new JFormattedTextField(formatter);
        Font panelFont = panel.getFont();
        minLengthField.setFont(panelFont);
        minLengthField.setValue(this.m_minLength);
        minLengthField.setColumns(2);
        FormattedTextFieldMacFix.apply(minLengthField);
        final JFormattedTextField maxLengthField = new JFormattedTextField(formatter);
        maxLengthField.setFont(panelFont);
        maxLengthField.setValue(this.m_maxLength);
        maxLengthField.setColumns(2);
        FormattedTextFieldMacFix.apply(maxLengthField);
        final JFormattedTextField regexField = new JFormattedTextField(new RegExFormatter());
        regexField.setFont(panelFont);
        regexField.setValue(this.m_regexPattern);
        regexField.setColumns(25);
        regexField.setInputVerifier(new RegExInputVerifier());
        regexField.setFocusLostBehavior(0);
        FormattedTextFieldMacFix.apply(regexField);
        DocumentAdapter listener = new DocumentAdapter(){

            public void textChanged(DocumentEvent e) {
                try {
                    regexField.commitEdit();
                    minLengthField.commitEdit();
                    maxLengthField.commitEdit();
                    PackageNamingConventionInspection.this.m_regexPattern = (Pattern)regexField.getValue();
                    PackageNamingConventionInspection.this.m_regex = PackageNamingConventionInspection.this.m_regexPattern.pattern();
                    PackageNamingConventionInspection.this.m_minLength = ((Number)minLengthField.getValue()).intValue();
                    PackageNamingConventionInspection.this.m_maxLength = ((Number)maxLengthField.getValue()).intValue();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        };
        Document regexDocument = regexField.getDocument();
        regexDocument.addDocumentListener((DocumentListener)listener);
        Document minLengthDocument = minLengthField.getDocument();
        minLengthDocument.addDocumentListener((DocumentListener)listener);
        Document maxLengthDocument = maxLengthField.getDocument();
        maxLengthDocument.addDocumentListener((DocumentListener)listener);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 13;
        constraints.fill = 2;
        panel.add((Component)patternLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 3;
        constraints.anchor = 17;
        panel.add((Component)regexField, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.anchor = 13;
        panel.add((Component)minLengthLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.anchor = 17;
        panel.add((Component)minLengthField, constraints);
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.anchor = 13;
        panel.add((Component)maxLengthLabel, constraints);
        constraints.gridx = 3;
        constraints.gridy = 1;
        constraints.anchor = 17;
        panel.add((Component)maxLengthField, constraints);
        return panel;
    }
}

