/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class CharUsedInArithmeticContextInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("char.used.in.arithmetic.context.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/CharUsedInArithmeticContextInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("char.used.in.arithmetic.context.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/CharUsedInArithmeticContextInspection.buildErrorString must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        InspectionGadgetsFix[] inspectionGadgetsFixArray;
        PsiExpression binaryExpression;
        PsiType type;
        ArrayList<InspectionGadgetsFix> result = new ArrayList<InspectionGadgetsFix>();
        PsiElement expression = (PsiElement)infos[0];
        PsiElement parent = expression.getParent();
        if (parent instanceof PsiExpression && (type = (binaryExpression = (PsiExpression)parent).getType()) != null && type != PsiType.CHAR) {
            String typeText = type.getCanonicalText();
            result.add(new CharUsedInArithmeticContentCastFix(typeText));
        }
        if (!(expression instanceof PsiLiteralExpression)) {
            inspectionGadgetsFixArray = result.toArray(new InspectionGadgetsFix[result.size()]);
            if (inspectionGadgetsFixArray == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/CharUsedInArithmeticContextInspection.buildFixes must not return null");
            return inspectionGadgetsFixArray;
        }
        while (parent instanceof PsiBinaryExpression) {
            binaryExpression = (PsiBinaryExpression)parent;
            if (TypeUtils.expressionHasType("java.lang.String", binaryExpression)) {
                result.add(new CharUsedInArithmeticContentFix());
                break;
            }
            parent = parent.getParent();
        }
        if ((inspectionGadgetsFixArray = result.toArray(new InspectionGadgetsFix[result.size()])) != null) return inspectionGadgetsFixArray;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/CharUsedInArithmeticContextInspection.buildFixes must not return null");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CharUsedInArithmeticContextVisitor();
    }

    private static class CharUsedInArithmeticContextVisitor
    extends BaseInspectionVisitor {
        private CharUsedInArithmeticContextVisitor() {
        }

        public void visitBinaryExpression(PsiBinaryExpression expression) {
            PsiExpression rhs;
            super.visitBinaryExpression(expression);
            PsiType type = expression.getType();
            if (type == null || type.equalsToText("java.lang.String")) {
                return;
            }
            IElementType tokenType = expression.getOperationTokenType();
            if (ComparisonUtils.isComparisonOperation(tokenType)) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            PsiType lhsType = lhs.getType();
            if (PsiType.CHAR.equals(lhsType)) {
                this.registerError((PsiElement)lhs, lhs);
            }
            if ((rhs = expression.getROperand()) == null) {
                return;
            }
            PsiType rhsType = rhs.getType();
            if (PsiType.CHAR.equals(rhsType)) {
                this.registerError((PsiElement)rhs, rhs);
            }
        }
    }

    private static class CharUsedInArithmeticContentCastFix
    extends InspectionGadgetsFix {
        private final String typeText;

        CharUsedInArithmeticContentCastFix(String typeText) {
            this.typeText = typeText;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("char.used.in.arithmetic.context.cast.quickfix", this.typeText);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/CharUsedInArithmeticContextInspection$CharUsedInArithmeticContentCastFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiExpression)) {
                return;
            }
            PsiExpression expression = (PsiExpression)element;
            String expressionText = expression.getText();
            CharUsedInArithmeticContentCastFix.replaceExpression(expression, '(' + this.typeText + ')' + expressionText);
        }
    }

    private static class CharUsedInArithmeticContentFix
    extends InspectionGadgetsFix {
        private CharUsedInArithmeticContentFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("char.used.in.arithmetic.context.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/CharUsedInArithmeticContextInspection$CharUsedInArithmeticContentFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiLiteralExpression)) {
                return;
            }
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)element;
            Object literal = literalExpression.getValue();
            if (!(literal instanceof Character)) {
                return;
            }
            CharUsedInArithmeticContentFix.replaceExpression((PsiExpression)literalExpression, "\"" + literal + '\"');
        }
    }
}

