/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiVariable;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;

public class VariableAssignedFromVisitor
extends JavaRecursiveElementVisitor {
    private boolean assignedFrom;
    @NotNull
    private final PsiVariable variable;

    public VariableAssignedFromVisitor(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableAssignedFromVisitor.<init> must not be null");
        }
        this.assignedFrom = false;
        this.variable = variable;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableAssignedFromVisitor.visitElement must not be null");
        }
        if (!this.assignedFrom) {
            super.visitElement(element);
        }
    }

    public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
        if (assignment == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableAssignedFromVisitor.visitAssignmentExpression must not be null");
        }
        if (this.assignedFrom) {
            return;
        }
        super.visitAssignmentExpression(assignment);
        PsiExpression arg = assignment.getRExpression();
        if (VariableAccessUtils.mayEvaluateToVariable(arg, this.variable)) {
            this.assignedFrom = true;
        }
    }

    public void visitDeclarationStatement(@NotNull PsiDeclarationStatement statement) {
        PsiElement[] declaredElements;
        if (statement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableAssignedFromVisitor.visitDeclarationStatement must not be null");
        }
        if (this.assignedFrom) {
            return;
        }
        super.visitDeclarationStatement(statement);
        for (PsiElement declaredElement : declaredElements = statement.getDeclaredElements()) {
            PsiVariable declaredVariable;
            PsiExpression initializer;
            if (!(declaredElement instanceof PsiVariable) || (initializer = (declaredVariable = (PsiVariable)declaredElement).getInitializer()) == null || !VariableAccessUtils.mayEvaluateToVariable(initializer, this.variable)) continue;
            this.assignedFrom = true;
            return;
        }
    }

    public void visitVariable(@NotNull PsiVariable var) {
        if (var == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableAssignedFromVisitor.visitVariable must not be null");
        }
        if (this.assignedFrom) {
            return;
        }
        super.visitVariable(var);
        PsiExpression arg = var.getInitializer();
        if (VariableAccessUtils.mayEvaluateToVariable(arg, this.variable)) {
            this.assignedFrom = true;
        }
    }

    public boolean isAssignedFrom() {
        return this.assignedFrom;
    }
}

