/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Query;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeakestTypeFinder {
    private WeakestTypeFinder() {
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    @NotNull
    public static Collection<PsiClass> calculateWeakestClassesNecessary(@NotNull PsiElement variableOrMethod, boolean useRighthandTypeAsWeakestTypeInAssignments, boolean useParameterizedTypeForCollectionMethods) {
        Collection<Object> collection;
        PsiType variableOrMethodType;
        if (variableOrMethod == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/WeakestTypeFinder.calculateWeakestClassesNecessary must not be null");
        }
        if (variableOrMethod instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)variableOrMethod;
            variableOrMethodType = variable.getType();
        } else {
            if (!(variableOrMethod instanceof PsiMethod)) throw new IllegalArgumentException("PsiMethod or PsiVariable expected: " + variableOrMethod);
            PsiMethod method = (PsiMethod)variableOrMethod;
            variableOrMethodType = method.getReturnType();
            if (PsiType.VOID.equals(variableOrMethodType)) {
                List list = Collections.EMPTY_LIST;
                collection = list;
                if (list != null) return collection;
                throw new IllegalStateException("@NotNull method com/siyeh/ig/psiutils/WeakestTypeFinder.calculateWeakestClassesNecessary must not return null");
            }
        }
        if (!(variableOrMethodType instanceof PsiClassType)) {
            List list = Collections.EMPTY_LIST;
            collection = list;
            if (list == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/psiutils/WeakestTypeFinder.calculateWeakestClassesNecessary must not return null");
            return collection;
        }
        PsiClassType variableOrMethodClassType = (PsiClassType)variableOrMethodType;
        PsiClass variableOrMethodClass = variableOrMethodClassType.resolve();
        if (variableOrMethodClass == null) {
            List list = Collections.EMPTY_LIST;
            collection = list;
            if (list == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/psiutils/WeakestTypeFinder.calculateWeakestClassesNecessary must not return null");
            return collection;
        }
        PsiManager manager = variableOrMethod.getManager();
        GlobalSearchScope scope = variableOrMethod.getResolveScope();
        Project project = manager.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiClass javaLangObjectClass = facade.findClass("java.lang.Object", scope);
        if (javaLangObjectClass == null || variableOrMethodClass.equals(javaLangObjectClass)) {
            List list = Collections.EMPTY_LIST;
            collection = list;
            if (list == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/psiutils/WeakestTypeFinder.calculateWeakestClassesNecessary must not return null");
            return collection;
        }
        Set<PsiClass> weakestTypeClasses = new HashSet<PsiClass>();
        weakestTypeClasses.add(javaLangObjectClass);
        Query query = ReferencesSearch.search((PsiElement)variableOrMethod);
        boolean hasUsages = false;
        for (PsiReference reference : query) {
            PsiType type;
            PsiType type2;
            PsiMethodCallExpression methodCallExpression;
            if (reference == null) continue;
            hasUsages = true;
            PsiElement referenceElement = reference.getElement();
            PsiElement referenceParent = referenceElement.getParent();
            if (referenceParent instanceof PsiMethodCallExpression) {
                referenceElement = referenceParent;
                referenceParent = referenceElement.getParent();
            }
            PsiElement referenceGrandParent = referenceParent.getParent();
            if (referenceParent instanceof PsiExpressionList) {
                if (!(referenceGrandParent instanceof PsiMethodCallExpression)) {
                    List list = Collections.EMPTY_LIST;
                    collection = list;
                    if (list == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/psiutils/WeakestTypeFinder.calculateWeakestClassesNecessary must not return null");
                    return collection;
                }
                methodCallExpression = (PsiMethodCallExpression)referenceGrandParent;
                if (!WeakestTypeFinder.findWeakestType(referenceElement, methodCallExpression, useParameterizedTypeForCollectionMethods, weakestTypeClasses)) {
                    List list = Collections.EMPTY_LIST;
                    collection = list;
                    if (list == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/psiutils/WeakestTypeFinder.calculateWeakestClassesNecessary must not return null");
                    return collection;
                }
            } else if (referenceGrandParent instanceof PsiMethodCallExpression) {
                methodCallExpression = (PsiMethodCallExpression)referenceGrandParent;
                if (!WeakestTypeFinder.findWeakestType(methodCallExpression, weakestTypeClasses)) {
                    List list = Collections.EMPTY_LIST;
                    collection = list;
                    if (list == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/psiutils/WeakestTypeFinder.calculateWeakestClassesNecessary must not return null");
                    return collection;
                }
            } else if (referenceParent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)referenceParent;
                if (!WeakestTypeFinder.findWeakestType(referenceElement, assignmentExpression, useRighthandTypeAsWeakestTypeInAssignments, weakestTypeClasses)) {
                    List list = Collections.EMPTY_LIST;
                    collection = list;
                    if (list == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/psiutils/WeakestTypeFinder.calculateWeakestClassesNecessary must not return null");
                    return collection;
                }
            } else if (referenceParent instanceof PsiVariable) {
                PsiVariable variable = (PsiVariable)referenceParent;
                type2 = variable.getType();
                if (!WeakestTypeFinder.checkType(type2, weakestTypeClasses)) {
                    List list = Collections.EMPTY_LIST;
                    collection = list;
                    if (list == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/psiutils/WeakestTypeFinder.calculateWeakestClassesNecessary must not return null");
                    return collection;
                }
            } else if (referenceParent instanceof PsiForeachStatement) {
                PsiForeachStatement foreachStatement = (PsiForeachStatement)referenceParent;
                if (foreachStatement.getIteratedValue() != referenceElement) {
                    List list = Collections.EMPTY_LIST;
                    collection = list;
                    if (list == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/psiutils/WeakestTypeFinder.calculateWeakestClassesNecessary must not return null");
                    return collection;
                }
                PsiClass javaLangIterableClass = facade.findClass("java.lang.Iterable", scope);
                if (javaLangIterableClass == null) {
                    List list = Collections.EMPTY_LIST;
                    collection = list;
                    if (list == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/psiutils/WeakestTypeFinder.calculateWeakestClassesNecessary must not return null");
                    return collection;
                }
                WeakestTypeFinder.checkClass(javaLangIterableClass, weakestTypeClasses);
            } else if (referenceParent instanceof PsiReturnStatement) {
                PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)referenceParent, PsiMethod.class);
                if (containingMethod == null) {
                    List list = Collections.EMPTY_LIST;
                    collection = list;
                    if (list == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/psiutils/WeakestTypeFinder.calculateWeakestClassesNecessary must not return null");
                    return collection;
                }
                type2 = containingMethod.getReturnType();
                if (!WeakestTypeFinder.checkType(type2, weakestTypeClasses)) {
                    List list = Collections.EMPTY_LIST;
                    collection = list;
                    if (list == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/psiutils/WeakestTypeFinder.calculateWeakestClassesNecessary must not return null");
                    return collection;
                }
            } else if (referenceParent instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)referenceParent;
                PsiElement target = referenceExpression.resolve();
                if (!(target instanceof PsiField)) {
                    List list = Collections.EMPTY_LIST;
                    collection = list;
                    if (list == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/psiutils/WeakestTypeFinder.calculateWeakestClassesNecessary must not return null");
                    return collection;
                }
                PsiField field = (PsiField)target;
                PsiClass containingClass = field.getContainingClass();
                WeakestTypeFinder.checkClass(containingClass, weakestTypeClasses);
            } else if (referenceParent instanceof PsiArrayInitializerExpression) {
                PsiArrayInitializerExpression arrayInitializerExpression = (PsiArrayInitializerExpression)referenceParent;
                if (!WeakestTypeFinder.findWeakestType(arrayInitializerExpression, weakestTypeClasses)) {
                    List list = Collections.EMPTY_LIST;
                    collection = list;
                    if (list == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/psiutils/WeakestTypeFinder.calculateWeakestClassesNecessary must not return null");
                    return collection;
                }
            } else if (referenceParent instanceof PsiThrowStatement) {
                PsiThrowStatement throwStatement = (PsiThrowStatement)referenceParent;
                if (!WeakestTypeFinder.findWeakestType(throwStatement, variableOrMethodClass, weakestTypeClasses)) {
                    List list = Collections.EMPTY_LIST;
                    collection = list;
                    if (list == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/psiutils/WeakestTypeFinder.calculateWeakestClassesNecessary must not return null");
                    return collection;
                }
            } else if (referenceParent instanceof PsiConditionalExpression) {
                PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)referenceParent;
                PsiExpression condition = conditionalExpression.getCondition();
                if (referenceElement.equals(condition)) {
                    List list = Collections.EMPTY_LIST;
                    collection = list;
                    if (list == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/psiutils/WeakestTypeFinder.calculateWeakestClassesNecessary must not return null");
                    return collection;
                }
                type = ExpectedTypeUtils.findExpectedType((PsiExpression)conditionalExpression, true);
                if (!WeakestTypeFinder.checkType(type, weakestTypeClasses)) {
                    List list = Collections.EMPTY_LIST;
                    collection = list;
                    if (list == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/psiutils/WeakestTypeFinder.calculateWeakestClassesNecessary must not return null");
                    return collection;
                }
            } else if (referenceParent instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)referenceParent;
                type2 = binaryExpression.getType();
                if (variableOrMethodType.equals(type2) && !WeakestTypeFinder.checkType(type2, weakestTypeClasses)) {
                    List list = Collections.EMPTY_LIST;
                    collection = list;
                    if (list == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/psiutils/WeakestTypeFinder.calculateWeakestClassesNecessary must not return null");
                    return collection;
                }
            } else {
                PsiNewExpression newExpression;
                PsiExpression qualifier;
                if (referenceParent instanceof PsiSwitchStatement) {
                    List list = Collections.EMPTY_LIST;
                    collection = list;
                    if (list == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/psiutils/WeakestTypeFinder.calculateWeakestClassesNecessary must not return null");
                    return collection;
                }
                if (referenceParent instanceof PsiPrefixExpression) {
                    List list = Collections.EMPTY_LIST;
                    collection = list;
                    if (list == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/psiutils/WeakestTypeFinder.calculateWeakestClassesNecessary must not return null");
                    return collection;
                }
                if (referenceParent instanceof PsiPostfixExpression) {
                    List list = Collections.EMPTY_LIST;
                    collection = list;
                    if (list == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/psiutils/WeakestTypeFinder.calculateWeakestClassesNecessary must not return null");
                    return collection;
                }
                if (referenceParent instanceof PsiIfStatement) {
                    List list = Collections.EMPTY_LIST;
                    collection = list;
                    if (list == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/psiutils/WeakestTypeFinder.calculateWeakestClassesNecessary must not return null");
                    return collection;
                }
                if (referenceParent instanceof PsiForStatement) {
                    List list = Collections.EMPTY_LIST;
                    collection = list;
                    if (list == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/psiutils/WeakestTypeFinder.calculateWeakestClassesNecessary must not return null");
                    return collection;
                }
                if (referenceParent instanceof PsiNewExpression && (qualifier = (newExpression = (PsiNewExpression)referenceParent).getQualifier()) != null) {
                    type = newExpression.getType();
                    if (!(type instanceof PsiClassType)) {
                        List list = Collections.EMPTY_LIST;
                        collection = list;
                        if (list == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/psiutils/WeakestTypeFinder.calculateWeakestClassesNecessary must not return null");
                        return collection;
                    }
                    PsiClassType classType = (PsiClassType)type;
                    PsiClass innerClass = classType.resolve();
                    if (innerClass == null) {
                        List list = Collections.EMPTY_LIST;
                        collection = list;
                        if (list == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/psiutils/WeakestTypeFinder.calculateWeakestClassesNecessary must not return null");
                        return collection;
                    }
                    PsiClass outerClass = innerClass.getContainingClass();
                    if (outerClass != null) {
                        WeakestTypeFinder.checkClass(outerClass, weakestTypeClasses);
                    }
                }
            }
            if (!weakestTypeClasses.contains(variableOrMethodClass) && !weakestTypeClasses.isEmpty()) continue;
            List list = Collections.EMPTY_LIST;
            collection = list;
            if (list == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/psiutils/WeakestTypeFinder.calculateWeakestClassesNecessary must not return null");
            return collection;
        }
        if (!hasUsages) {
            List list = Collections.EMPTY_LIST;
            collection = list;
            if (list == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/psiutils/WeakestTypeFinder.calculateWeakestClassesNecessary must not return null");
            return collection;
        }
        Set<PsiClass> set = weakestTypeClasses = WeakestTypeFinder.filterAccessibleClasses(weakestTypeClasses, variableOrMethod);
        collection = set;
        if (set == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/psiutils/WeakestTypeFinder.calculateWeakestClassesNecessary must not return null");
        return collection;
    }

    private static boolean findWeakestType(PsiElement referenceElement, PsiMethodCallExpression methodCallExpression, boolean useParameterizedTypeForCollectionMethods, Set<PsiClass> weakestTypeClasses) {
        PsiClassType classType;
        PsiType[] parameterTypes;
        PsiType qualifierType;
        PsiReferenceExpression methodExpression;
        PsiExpression qualifier;
        PsiClass containingClass;
        PsiType type;
        if (!(referenceElement instanceof PsiExpression)) {
            return false;
        }
        JavaResolveResult resolveResult = methodCallExpression.resolveMethodGenerics();
        PsiMethod method = (PsiMethod)resolveResult.getElement();
        if (method == null) {
            return false;
        }
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        PsiExpressionList expressionList = methodCallExpression.getArgumentList();
        PsiExpression[] expressions = expressionList.getExpressions();
        int index = WeakestTypeFinder.findElementIndexInExpressionList(referenceElement, expressions);
        if (index < 0) {
            return false;
        }
        PsiParameterList parameterList = method.getParameterList();
        if (parameterList.getParametersCount() == 0) {
            return false;
        }
        PsiParameter[] parameters = parameterList.getParameters();
        if (index < parameters.length) {
            PsiParameter parameter = parameters[index];
            type = parameter.getType();
        } else {
            PsiParameter parameter = parameters[parameters.length - 1];
            type = parameter.getType();
            if (!(type instanceof PsiEllipsisType)) {
                return false;
            }
        }
        if (!useParameterizedTypeForCollectionMethods) {
            return WeakestTypeFinder.checkType(type, substitutor, weakestTypeClasses);
        }
        String methodName = method.getName();
        if (("remove".equals(methodName) || "get".equals(methodName) || "containsKey".equals(methodName) || "containsValue".equals(methodName) || "contains".equals(methodName) || "indexOf".equals(methodName) || "lastIndexOf".equals(methodName)) && (ClassUtils.isSubclass(containingClass = method.getContainingClass(), "java.util.Map") || ClassUtils.isSubclass(containingClass, "java.util.Collection")) && (qualifier = (methodExpression = methodCallExpression.getMethodExpression()).getQualifierExpression()) != null && (qualifierType = qualifier.getType()) instanceof PsiClassType && (parameterTypes = (classType = (PsiClassType)qualifierType).getParameters()).length > 0) {
            PsiType parameterType = parameterTypes[0];
            PsiExpression expression = expressions[index];
            PsiType expressionType = expression.getType();
            if (expressionType == null || parameterType == null || !parameterType.isAssignableFrom(expressionType)) {
                return false;
            }
            return WeakestTypeFinder.checkType(parameterType, substitutor, weakestTypeClasses);
        }
        return WeakestTypeFinder.checkType(type, substitutor, weakestTypeClasses);
    }

    private static boolean checkType(@Nullable PsiType type, @NotNull PsiSubstitutor substitutor, @NotNull Collection<PsiClass> weakestTypeClasses) {
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/WeakestTypeFinder.checkType must not be null");
        }
        if (weakestTypeClasses == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/siyeh/ig/psiutils/WeakestTypeFinder.checkType must not be null");
        }
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)type;
        PsiClass aClass = classType.resolve();
        if (aClass == null) {
            return false;
        }
        if (aClass instanceof PsiTypeParameter) {
            PsiType substitution = substitutor.substitute((PsiTypeParameter)aClass);
            return WeakestTypeFinder.checkType(substitution, weakestTypeClasses);
        }
        WeakestTypeFinder.checkClass(aClass, weakestTypeClasses);
        return true;
    }

    private static boolean findWeakestType(PsiMethodCallExpression methodCallExpression, Set<PsiClass> weakestTypeClasses) {
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        PsiElement target = methodExpression.resolve();
        if (!(target instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)target;
        PsiReferenceList throwsList = method.getThrowsList();
        PsiClassType[] classTypes = throwsList.getReferencedTypes();
        HashSet<PsiClassType> thrownTypes = new HashSet<PsiClassType>(Arrays.asList(classTypes));
        PsiMethod[] superMethods = method.findDeepestSuperMethods();
        boolean checked = false;
        if (superMethods.length > 0) {
            PsiType expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)methodCallExpression, false);
            for (PsiMethod superMethod : superMethods) {
                PsiType returnType = superMethod.getReturnType();
                if (expectedType != null && returnType != null && !expectedType.isAssignableFrom(returnType) || WeakestTypeFinder.throwsIncompatibleException(superMethod, thrownTypes) || !WeakestTypeFinder.isAccessibleFrom(superMethod, (PsiElement)methodCallExpression)) continue;
                PsiClass containingClass = superMethod.getContainingClass();
                WeakestTypeFinder.checkClass(containingClass, weakestTypeClasses);
                checked = true;
            }
        }
        if (!checked) {
            PsiClassType classType;
            PsiClass aClass;
            PsiType returnType = method.getReturnType();
            if (returnType instanceof PsiClassType && (aClass = (classType = (PsiClassType)returnType).resolve()) instanceof PsiTypeParameter) {
                return false;
            }
            PsiClass containingClass = method.getContainingClass();
            WeakestTypeFinder.checkClass(containingClass, weakestTypeClasses);
        }
        return true;
    }

    private static boolean findWeakestType(PsiElement referenceElement, PsiAssignmentExpression assignmentExpression, boolean useRighthandTypeAsWeakestTypeInAssignments, Set<PsiClass> weakestTypeClasses) {
        IElementType tokenType = assignmentExpression.getOperationTokenType();
        if (JavaTokenType.EQ != tokenType) {
            return false;
        }
        PsiExpression lhs = assignmentExpression.getLExpression();
        PsiExpression rhs = assignmentExpression.getRExpression();
        PsiType lhsType = lhs.getType();
        if (referenceElement.equals(rhs)) {
            if (!WeakestTypeFinder.checkType(lhsType, weakestTypeClasses)) {
                return false;
            }
        } else if (useRighthandTypeAsWeakestTypeInAssignments) {
            if (rhs == null) {
                return false;
            }
            if (!(rhs instanceof PsiNewExpression) || !(rhs instanceof PsiTypeCastExpression)) {
                PsiType rhsType = rhs.getType();
                if (lhsType == null || lhsType.equals(rhsType)) {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean findWeakestType(PsiArrayInitializerExpression arrayInitializerExpression, Set<PsiClass> weakestTypeClasses) {
        PsiType type = arrayInitializerExpression.getType();
        if (!(type instanceof PsiArrayType)) {
            return false;
        }
        PsiArrayType arrayType = (PsiArrayType)type;
        PsiType componentType = arrayType.getComponentType();
        return WeakestTypeFinder.checkType(componentType, weakestTypeClasses);
    }

    private static boolean findWeakestType(PsiThrowStatement throwStatement, PsiClass variableOrMethodClass, Set<PsiClass> weakestTypeClasses) {
        PsiManager manager = throwStatement.getManager();
        PsiClassType runtimeExceptionType = PsiType.getJavaLangRuntimeException((PsiManager)manager, (GlobalSearchScope)throwStatement.getResolveScope());
        PsiClass runtimeExceptionClass = runtimeExceptionType.resolve();
        if (runtimeExceptionClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)variableOrMethodClass, (PsiClass)runtimeExceptionClass, (boolean)true)) {
            if (!WeakestTypeFinder.checkType((PsiType)runtimeExceptionType, weakestTypeClasses)) {
                return false;
            }
        } else {
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)throwStatement, PsiMethod.class);
            if (method == null) {
                return false;
            }
            PsiReferenceList throwsList = method.getThrowsList();
            PsiClassType[] referencedTypes = throwsList.getReferencedTypes();
            boolean checked = false;
            for (PsiClassType referencedType : referencedTypes) {
                PsiClass throwableClass = referencedType.resolve();
                if (throwableClass == null || !InheritanceUtil.isInheritorOrSelf((PsiClass)variableOrMethodClass, (PsiClass)throwableClass, (boolean)true) || !WeakestTypeFinder.checkType((PsiType)referencedType, weakestTypeClasses)) continue;
                checked = true;
                break;
            }
            if (!checked) {
                return false;
            }
        }
        return true;
    }

    private static boolean throwsIncompatibleException(PsiMethod method, Collection<PsiClassType> exceptionTypes) {
        PsiClassType[] superThrownTypes;
        PsiReferenceList superThrowsList = method.getThrowsList();
        for (PsiClassType superThrownType : superThrownTypes = superThrowsList.getReferencedTypes()) {
            if (exceptionTypes.contains(superThrownType)) {
                return true;
            }
            PsiClass aClass = superThrownType.resolve();
            if (aClass == null) {
                return true;
            }
            if (ClassUtils.isSubclass(aClass, "java.lang.RuntimeException") || ClassUtils.isSubclass(aClass, "java.lang.Error")) continue;
            return true;
        }
        return false;
    }

    private static boolean checkType(@Nullable PsiType type, @NotNull Collection<PsiClass> weakestTypeClasses) {
        if (weakestTypeClasses == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/WeakestTypeFinder.checkType must not be null");
        }
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)type;
        PsiClass aClass = classType.resolve();
        if (aClass == null) {
            return false;
        }
        WeakestTypeFinder.checkClass(aClass, weakestTypeClasses);
        return true;
    }

    public static Set<PsiClass> filterAccessibleClasses(Set<PsiClass> weakestTypeClasses, PsiElement context) {
        HashSet<PsiClass> result = new HashSet<PsiClass>();
        for (PsiClass weakestTypeClass : weakestTypeClasses) {
            if (WeakestTypeFinder.isAccessibleFrom(weakestTypeClass, context)) {
                result.add(weakestTypeClass);
                continue;
            }
            PsiClass visibleInheritor = WeakestTypeFinder.getVisibleInheritor(weakestTypeClass, context);
            if (visibleInheritor == null) continue;
            result.add(visibleInheritor);
        }
        return result;
    }

    @Nullable
    private static PsiClass getVisibleInheritor(PsiClass superClass, PsiElement context) {
        Query search = DirectClassInheritorsSearch.search((PsiClass)superClass, (SearchScope)context.getResolveScope());
        for (PsiClass aClass : search) {
            if (!superClass.isInheritor(aClass, true)) continue;
            if (WeakestTypeFinder.isAccessibleFrom(aClass, context)) {
                return aClass;
            }
            return WeakestTypeFinder.getVisibleInheritor(aClass, context);
        }
        return null;
    }

    private static void checkClass(@NotNull PsiClass aClass, @NotNull Collection<PsiClass> weakestTypeClasses) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/WeakestTypeFinder.checkClass must not be null");
        }
        if (weakestTypeClasses == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/WeakestTypeFinder.checkClass must not be null");
        }
        boolean shouldAdd = true;
        Iterator<PsiClass> iterator = weakestTypeClasses.iterator();
        while (iterator.hasNext()) {
            PsiClass weakestTypeClass = iterator.next();
            if (!weakestTypeClass.equals(aClass)) {
                if (aClass.isInheritor(weakestTypeClass, true)) {
                    iterator.remove();
                    continue;
                }
                if (weakestTypeClass.isInheritor(aClass, true)) {
                    shouldAdd = false;
                    continue;
                }
                iterator.remove();
                shouldAdd = false;
                continue;
            }
            shouldAdd = false;
        }
        if (shouldAdd) {
            weakestTypeClasses.add(aClass);
        }
    }

    private static boolean isAccessibleFrom(PsiClass aClass, PsiElement context) {
        if (aClass.hasModifierProperty("public")) {
            return true;
        }
        if (aClass.hasModifierProperty("private")) {
            return false;
        }
        PsiClass referencingClass = ClassUtils.getContainingClass(context);
        if (referencingClass == null) {
            return false;
        }
        if (context.equals(aClass)) {
            return true;
        }
        return ClassUtils.inSamePackage((PsiElement)aClass, (PsiElement)referencingClass);
    }

    private static boolean isAccessibleFrom(PsiMethod method, PsiElement context) {
        if (method.hasModifierProperty("public")) {
            return true;
        }
        if (method.hasModifierProperty("private")) {
            return false;
        }
        PsiClass referencingClass = ClassUtils.getContainingClass(context);
        if (referencingClass == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (method.hasModifierProperty("protected") && referencingClass.isInheritor(containingClass, true)) {
            return true;
        }
        return method.hasModifierProperty("packageLocal") && ClassUtils.inSamePackage((PsiElement)referencingClass, (PsiElement)containingClass);
    }

    private static int findElementIndexInExpressionList(@NotNull PsiElement element, @NotNull PsiExpression[] expressions) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/WeakestTypeFinder.findElementIndexInExpressionList must not be null");
        }
        if (expressions == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/WeakestTypeFinder.findElementIndexInExpressionList must not be null");
        }
        for (int i = 0; i < expressions.length; ++i) {
            PsiExpression anExpression = expressions[i];
            if (!element.equals(anExpression)) continue;
            return i;
        }
        return -1;
    }
}

