/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.InitializationUtils;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.NotNull;

public class TransientFieldNotInitializedInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("transient.field.not.initialized.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/TransientFieldNotInitializedInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("transient.field.not.initialized.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/TransientFieldNotInitializedInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReadObjectInitializationVisitor();
    }

    private static class ReadObjectInitializationVisitor
    extends BaseInspectionVisitor {
        private ReadObjectInitializationVisitor() {
        }

        public void visitField(PsiField field) {
            super.visitField(field);
            if (!field.hasModifierProperty("transient")) {
                return;
            }
            PsiClass containingClass = field.getContainingClass();
            if (!SerializationUtils.isSerializable(containingClass)) {
                return;
            }
            PsiExpression initializer = field.getInitializer();
            if (initializer == null && !ReadObjectInitializationVisitor.isInitializedInInitializer(field, containingClass) && !ReadObjectInitializationVisitor.isInitializedInConstructors(field, containingClass)) {
                return;
            }
            if (SerializationUtils.hasReadObject(containingClass)) {
                return;
            }
            this.registerFieldError(field, new Object[0]);
        }

        private static boolean isInitializedInConstructors(@NotNull PsiField field, @NotNull PsiClass aClass) {
            if (field == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/serialization/TransientFieldNotInitializedInspection$ReadObjectInitializationVisitor.isInitializedInConstructors must not be null");
            }
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/serialization/TransientFieldNotInitializedInspection$ReadObjectInitializationVisitor.isInitializedInConstructors must not be null");
            }
            PsiMethod[] constructors = aClass.getConstructors();
            if (constructors.length == 0) {
                return false;
            }
            for (PsiMethod constructor : constructors) {
                if (InitializationUtils.methodAssignsVariableOrFails(constructor, (PsiVariable)field)) continue;
                return false;
            }
            return true;
        }

        private static boolean isInitializedInInitializer(@NotNull PsiField field, @NotNull PsiClass aClass) {
            PsiClassInitializer[] initializers;
            if (field == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/serialization/TransientFieldNotInitializedInspection$ReadObjectInitializationVisitor.isInitializedInInitializer must not be null");
            }
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/serialization/TransientFieldNotInitializedInspection$ReadObjectInitializationVisitor.isInitializedInInitializer must not be null");
            }
            for (PsiClassInitializer initializer : initializers = aClass.getInitializers()) {
                PsiCodeBlock body;
                if (initializer.hasModifierProperty("static") || !InitializationUtils.blockAssignsVariableOrFails(body = initializer.getBody(), (PsiVariable)field)) continue;
                return true;
            }
            return false;
        }
    }
}

