/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.ui;

import com.intellij.ide.DataManager;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.ui.IGTable;
import com.siyeh.ig.ui.ListWrappingTableModel;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ListSelectionModel;

public class TreeClassChooserAction
extends AbstractAction {
    private final IGTable table;
    private final String chooserTitle;

    public TreeClassChooserAction(IGTable table, String chooserTitle) {
        this.table = table;
        this.chooserTitle = chooserTitle;
        this.putValue("Name", InspectionGadgetsBundle.message("button.add", new Object[0]));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int rowIndex;
        DataManager dataManager = DataManager.getInstance();
        DataContext dataContext = dataManager.getDataContext();
        Project project = (Project)DataKeys.PROJECT.getData(dataContext);
        TreeClassChooserFactory chooserFactory = TreeClassChooserFactory.getInstance((Project)project);
        TreeClassChooser classChooser = chooserFactory.createAllProjectScopeChooser(this.chooserTitle);
        classChooser.showDialog();
        PsiClass selectedClass = classChooser.getSelectedClass();
        if (selectedClass == null) {
            return;
        }
        String qualifiedName = selectedClass.getQualifiedName();
        ListWrappingTableModel tableModel = this.table.getModel();
        int index = tableModel.indexOf(qualifiedName, 0);
        if (index < 0) {
            tableModel.addRow(qualifiedName);
            rowIndex = tableModel.getRowCount() - 1;
        } else {
            rowIndex = index;
        }
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        selectionModel.setSelectionInterval(rowIndex, rowIndex);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Rectangle rectangle = TreeClassChooserAction.this.table.getCellRect(rowIndex, 0, true);
                TreeClassChooserAction.this.table.scrollRectToVisible(rectangle);
            }
        });
    }
}

