/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.binding;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.uiDesigner.binding.FormClassIndex;
import java.util.List;

public class FormsRenamer
extends AutomaticRenamer {
    public String nameToCanonicalName(String name, PsiNamedElement psiFile) {
        if (name.endsWith(".form")) {
            return name.substring(0, name.length() - ".form".length());
        }
        return name;
    }

    public String canonicalNameToName(String canonicalName, PsiNamedElement psiFile) {
        return canonicalName.contains(".") ? canonicalName : canonicalName + ".form";
    }

    public FormsRenamer(PsiClass aClass, String newClassName) {
        if (aClass.getQualifiedName() != null) {
            List<PsiFile> forms = FormClassIndex.findFormsBoundToClass(aClass);
            this.myElements.addAll(forms);
            this.suggestAllNames(aClass.getName(), newClassName);
        }
    }

    public boolean isSelectedByDefault() {
        return true;
    }

    public String getDialogTitle() {
        return RefactoringBundle.message((String)"rename.bound.forms.title");
    }

    public String getDialogDescription() {
        return RefactoringBundle.message((String)"rename.forms.with.the.following.names.to");
    }

    public String entityName() {
        return RefactoringBundle.message((String)"entity.name.form");
    }
}

