/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.editor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.editor.MyEditorState;
import com.intellij.uiDesigner.editor.UIFormEditor;
import com.intellij.util.ArrayUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public final class UIFormEditorProvider
implements FileEditorProvider,
DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.editor.UIFormEditorProvider");

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/editor/UIFormEditorProvider.accept must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/uiDesigner/editor/UIFormEditorProvider.accept must not be null");
        }
        return FileTypeManager.getInstance().getFileTypeByFile(file) == StdFileTypes.GUI_DESIGNER_FORM && !StdFileTypes.GUI_DESIGNER_FORM.isBinary() && ModuleUtil.findModuleForFile((VirtualFile)file, (Project)project) != null;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/editor/UIFormEditorProvider.createEditor must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/uiDesigner/editor/UIFormEditorProvider.createEditor must not be null");
        }
        LOG.assertTrue(this.accept(project, file));
        UIFormEditor uIFormEditor = new UIFormEditor(project, file);
        if (uIFormEditor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/editor/UIFormEditorProvider.createEditor must not return null");
        }
        return uIFormEditor;
    }

    public void disposeEditor(@NotNull FileEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/editor/UIFormEditorProvider.disposeEditor must not be null");
        }
        Disposer.dispose((Disposable)editor);
    }

    @NotNull
    public FileEditorState readState(@NotNull Element element, @NotNull Project project, @NotNull VirtualFile file) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/editor/UIFormEditorProvider.readState must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/uiDesigner/editor/UIFormEditorProvider.readState must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/uiDesigner/editor/UIFormEditorProvider.readState must not be null");
        }
        MyEditorState myEditorState = new MyEditorState(-1L, ArrayUtil.EMPTY_STRING_ARRAY);
        if (myEditorState == null) {
            throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/editor/UIFormEditorProvider.readState must not return null");
        }
        return myEditorState;
    }

    public void writeState(@NotNull FileEditorState state, @NotNull Project project, @NotNull Element element) {
        if (state == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/editor/UIFormEditorProvider.writeState must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/uiDesigner/editor/UIFormEditorProvider.writeState must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/uiDesigner/editor/UIFormEditorProvider.writeState must not be null");
        }
    }

    @NotNull
    public String getEditorTypeId() {
        if ("ui-designer" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/editor/UIFormEditorProvider.getEditorTypeId must not return null");
        }
        return "ui-designer";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = ApplicationManagerEx.getApplicationEx().isInternal() ? FileEditorPolicy.PLACE_BEFORE_DEFAULT_EDITOR : FileEditorPolicy.HIDE_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/editor/UIFormEditorProvider.getPolicy must not return null");
        }
        return fileEditorPolicy;
    }
}

