/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.editors;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.uiDesigner.lw.FontDescriptor;
import com.intellij.uiDesigner.propertyInspector.InplaceContext;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.editors.FontEditorDialog;
import com.intellij.uiDesigner.propertyInspector.properties.IntroFontProperty;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class FontEditor
extends PropertyEditor<FontDescriptor> {
    private final TextFieldWithBrowseButton myTextField = new TextFieldWithBrowseButton();
    private FontDescriptor myValue;
    private Project myProject;
    private final String myPropertyName;

    public FontEditor(String propertyName) {
        this.myPropertyName = propertyName;
        this.myTextField.getTextField().setBorder(null);
        this.myTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontEditor.this.showFontEditorDialog();
            }
        });
    }

    private void showFontEditorDialog() {
        FontEditorDialog dlg = new FontEditorDialog(this.myProject, this.myPropertyName);
        dlg.setValue(this.myValue);
        dlg.show();
        if (dlg.getExitCode() == 0) {
            this.myValue = dlg.getValue();
            this.myTextField.setText(IntroFontProperty.descriptorToString(this.myValue));
            this.fireValueCommitted(true, false);
        }
    }

    @Override
    public FontDescriptor getValue() throws Exception {
        return this.myValue;
    }

    @Override
    public JComponent getComponent(RadComponent component, FontDescriptor value, InplaceContext inplaceContext) {
        this.myProject = component.getModule().getProject();
        this.myValue = value != null ? value : new FontDescriptor(null, -1, -1);
        this.myTextField.setText(IntroFontProperty.descriptorToString(this.myValue));
        return this.myTextField;
    }

    @Override
    public void updateUI() {
        SwingUtilities.updateComponentTreeUI((Component)this.myTextField);
    }
}

