/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.editors.string;

import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.lw.StringDescriptor;
import com.intellij.uiDesigner.propertyInspector.editors.string.NewKeyDialog;
import com.intellij.uiDesigner.propertyInspector.editors.string.StringEditorDialog;
import com.intellij.util.ui.Table;
import gnu.trove.TObjectIntHashMap;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class KeyChooserDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.propertyInspector.editors.string.KeyChooserDialog");
    private final PropertiesFile myBundle;
    private final String myBundleName;
    private ArrayList<Pair<String, String>> myPairs;
    private final JComponent myCenterPanel;
    private final Table myTable;
    @NonNls
    private static final String NULL = "null";
    private final MyTableModel myModel;
    private final GuiEditor myEditor;
    private static final String OK_ACTION = "OkAction";

    public KeyChooserDialog(Component parent, @NotNull PropertiesFile bundle, @NotNull String bundleName, String keyToPreselect, GuiEditor editor) {
        if (bundle == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/uiDesigner/propertyInspector/editors/string/KeyChooserDialog.<init> must not be null");
        }
        if (bundleName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/uiDesigner/propertyInspector/editors/string/KeyChooserDialog.<init> must not be null");
        }
        super(parent, true);
        this.myEditor = editor;
        this.myBundle = bundle;
        this.myBundleName = bundleName;
        this.setTitle(UIDesignerBundle.message("title.chooser.value", new Object[0]));
        this.fillPropertyList();
        this.myModel = new MyTableModel();
        this.myTable = new Table((TableModel)this.myModel);
        this.myTable.getSelectionModel().setSelectionMode(0);
        new MySpeedSearch(this.myTable);
        this.myCenterPanel = ScrollPaneFactory.createScrollPane((JComponent)this.myTable);
        this.myTable.getInputMap().put(KeyStroke.getKeyStroke(10, 0), OK_ACTION);
        this.myTable.getActionMap().put(OK_ACTION, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyChooserDialog.this.getOKAction().actionPerformed(e);
            }
        });
        FontMetrics metrics = this.myTable.getFontMetrics(this.myTable.getFont());
        int width = 0;
        for (int i = this.myPairs.size() - 1; i >= 0; --i) {
            Pair<String, String> pair = this.myPairs.get(i);
            width = Math.max(width, metrics.stringWidth((String)pair.getFirst()));
        }
        width += 30;
        width = Math.max(width, metrics.stringWidth(this.myModel.getColumnName(0)));
        TableColumn keyColumn = this.myTable.getColumnModel().getColumn(0);
        keyColumn.setMaxWidth(width);
        keyColumn.setMinWidth(width);
        this.selectKey(keyToPreselect);
        this.init();
        this.myTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!e.isPopupTrigger() && e.getClickCount() == 2) {
                    KeyChooserDialog.this.doOKAction();
                }
            }
        });
    }

    private void fillPropertyList() {
        this.myPairs = new ArrayList();
        List properties = this.myBundle.getProperties();
        for (Property property : properties) {
            String key = property.getUnescapedKey();
            String value = property.getValue();
            if (key == null) continue;
            this.myPairs.add((Pair<String, String>)new Pair((Object)key, (Object)(value != null ? value : NULL)));
        }
        Collections.sort(this.myPairs, new MyPairComparator());
    }

    private void selectKey(String keyToPreselect) {
        int indexToPreselect = -1;
        for (int i = this.myPairs.size() - 1; i >= 0; --i) {
            Pair<String, String> pair = this.myPairs.get(i);
            if (!((String)pair.getFirst()).equals(keyToPreselect)) continue;
            indexToPreselect = i;
            break;
        }
        if (indexToPreselect != -1) {
            this.selectElementAt(indexToPreselect);
        }
    }

    protected Action[] createLeftSideActions() {
        return new Action[]{new NewKeyValueAction()};
    }

    private void selectElementAt(int index) {
        this.myTable.getSelectionModel().setSelectionInterval(index, index);
        this.myTable.scrollRectToVisible(this.myTable.getCellRect(index, 0, true));
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTable;
    }

    @Nullable
    StringDescriptor getDescriptor() {
        int selectedRow = this.myTable.getSelectedRow();
        if (selectedRow < 0 || selectedRow >= this.myTable.getRowCount()) {
            return null;
        }
        Pair<String, String> pair = this.myPairs.get(selectedRow);
        StringDescriptor descriptor = new StringDescriptor(this.myBundleName, (String)pair.getFirst());
        descriptor.setResolvedValue((String)pair.getSecond());
        return descriptor;
    }

    protected JComponent createCenterPanel() {
        return this.myCenterPanel;
    }

    private class NewKeyValueAction
    extends AbstractAction {
        public NewKeyValueAction() {
            this.putValue("Name", UIDesignerBundle.message("key.chooser.new.property", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NewKeyDialog dlg = new NewKeyDialog(KeyChooserDialog.this.getWindow());
            dlg.show();
            if (dlg.isOK()) {
                if (!StringEditorDialog.saveCreatedProperty(KeyChooserDialog.this.myBundle, dlg.getName(), dlg.getValue(), KeyChooserDialog.this.myEditor.getPsiFile())) {
                    return;
                }
                KeyChooserDialog.this.fillPropertyList();
                KeyChooserDialog.this.myModel.update();
                KeyChooserDialog.this.selectKey(dlg.getName());
            }
        }
    }

    private class MySpeedSearch
    extends SpeedSearchBase<Table> {
        private TObjectIntHashMap<Object> myElements;
        private Object[] myElementsArray;

        public MySpeedSearch(Table component) {
            super((JComponent)component);
        }

        public int getSelectedIndex() {
            return ((Table)this.myComponent).getSelectedRow();
        }

        public Object[] getAllElements() {
            if (this.myElements == null) {
                this.myElements = new TObjectIntHashMap();
                this.myElementsArray = KeyChooserDialog.this.myPairs.toArray();
                for (int idx = 0; idx < this.myElementsArray.length; ++idx) {
                    Object element = this.myElementsArray[idx];
                    this.myElements.put(element, idx);
                }
            }
            return this.myElementsArray;
        }

        public String getElementText(Object element) {
            return (String)((Pair)element).getFirst();
        }

        public void selectElement(Object element, String selectedText) {
            int index = this.myElements.get(element);
            KeyChooserDialog.this.selectElementAt(index);
        }
    }

    private final class MyTableModel
    extends AbstractTableModel {
        private MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return UIDesignerBundle.message("column.key", new Object[0]);
            }
            if (column == 1) {
                return UIDesignerBundle.message("column.value", new Object[0]);
            }
            throw new IllegalArgumentException("unknown column: " + column);
        }

        public Class getColumnClass(int column) {
            if (column == 0) {
                return String.class;
            }
            if (column == 1) {
                return String.class;
            }
            throw new IllegalArgumentException("unknown column: " + column);
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return ((Pair)KeyChooserDialog.this.myPairs.get(row)).getFirst();
            }
            if (column == 1) {
                return ((Pair)KeyChooserDialog.this.myPairs.get(row)).getSecond();
            }
            throw new IllegalArgumentException("unknown column: " + column);
        }

        @Override
        public int getRowCount() {
            return KeyChooserDialog.this.myPairs.size();
        }

        public void update() {
            this.fireTableDataChanged();
        }
    }

    private static final class MyPairComparator
    implements Comparator<Pair<String, String>> {
        private MyPairComparator() {
        }

        @Override
        public int compare(Pair<String, String> p1, Pair<String, String> p2) {
            return ((String)p1.getFirst()).compareToIgnoreCase((String)p2.getFirst());
        }
    }
}

