/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.lang.properties.references.PropertyReferenceBase;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyRenameHandler
extends PsiElementRenameHandler {
    public boolean isAvailableOnDataContext(DataContext dataContext) {
        Editor editor = (Editor)LangDataKeys.EDITOR.getData(dataContext);
        return editor != null && PropertyRenameHandler.getPsiElement(editor) != null;
    }

    @Nullable
    private static PsiElement getPsiElement(Editor editor) {
        PsiReference reference = TargetElementUtilBase.findReference((Editor)editor);
        if (reference instanceof PropertyReferenceBase) {
            ResolveResult[] resolveResults = ((PropertyReferenceBase)reference).multiResolve(false);
            return resolveResults.length > 0 ? resolveResults[0].getElement() : null;
        }
        return null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/PropertyRenameHandler.invoke must not be null");
        }
        PsiElement element = PropertyRenameHandler.getPsiElement(editor);
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement nameSuggestionContext = file.findElementAt(editor.getCaretModel().getOffset());
        PropertyRenameHandler.invoke((PsiElement)element, (Project)project, (PsiElement)nameSuggestionContext, (Editor)editor);
    }
}

