/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.projectView;

import com.intellij.ide.DeleteProvider;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import java.util.List;

class ResourceBundleDeleteProvider
implements DeleteProvider {
    private final ResourceBundle myResourceBundle;

    public ResourceBundleDeleteProvider(ResourceBundle resourceBundle) {
        this.myResourceBundle = resourceBundle;
    }

    public void deleteElement(DataContext dataContext) {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        List<PropertiesFile> propertiesFiles = this.myResourceBundle.getPropertiesFiles(project);
        PropertiesFile[] array = propertiesFiles.toArray(new PropertiesFile[propertiesFiles.size()]);
        new SafeDeleteHandler().invoke(project, (PsiElement[])array, dataContext);
    }

    public boolean canDeleteElement(DataContext dataContext) {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        return project != null;
    }
}

