/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.openapi.components.PathMacroMap;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;

public class ReplacePathToMacroMap
extends PathMacroMap {
    private List<String> myPathsIndex = null;
    private static final Comparator<Map.Entry<String, String>> PATHS_COMPARATOR = new Comparator<Map.Entry<String, String>>(){

        @Override
        public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
            int idx2;
            int idx1 = this.getIndex(o1);
            if (idx1 != (idx2 = this.getIndex(o2))) {
                return idx1 - idx2;
            }
            return o2.getKey().length() - o1.getKey().length();
        }

        private int getIndex(Map.Entry<String, String> s) {
            if (s.getValue().indexOf("..") >= 0) {
                return 3;
            }
            if (s.getValue().indexOf("$MODULE_DIR$") >= 0) {
                return 1;
            }
            if (s.getValue().indexOf("$PROJECT_DIR$") >= 0) {
                return 1;
            }
            return 2;
        }
    };
    @NonNls
    private static final String[] PROTOCOLS = new String[]{"file", "jar"};

    public void addMacroReplacement(String path, String macroName) {
        String p = ReplacePathToMacroMap.quotePath(path);
        String m = "$" + macroName + "$";
        this.put(p, m);
        for (String protocol : PROTOCOLS) {
            this.put(protocol + ":" + p, protocol + ":" + m);
            this.put(protocol + ":/" + p, protocol + "://" + m);
            this.put(protocol + "://" + p, protocol + "://" + m);
        }
    }

    @Override
    public String substitute(String text, boolean caseSensitive) {
        for (String path : this.getPathIndex()) {
            String macro = this.get(path);
            text = ReplacePathToMacroMap.replacePathMacro(text, path, macro, caseSensitive);
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String replacePathMacro(String text, String path, String macro, boolean caseSensitive) {
        if (text.length() < path.length() || path.length() == 0) {
            return text;
        }
        boolean startsWith = caseSensitive ? text.startsWith(path) : StringUtil.startsWithIgnoreCase((String)text, (String)path);
        if (!startsWith) {
            return text;
        }
        StringBuilder newText = StringBuilderSpinAllocator.alloc();
        try {
            int endOfOccurence = path.length();
            boolean isWindowsRoot = path.endsWith(":/");
            if (!isWindowsRoot && endOfOccurence < text.length() && text.charAt(endOfOccurence) != '/' && !text.substring(endOfOccurence).startsWith("!/")) {
                String string = text;
                return string;
            }
            newText.append(macro);
            newText.append(text.substring(endOfOccurence));
            String string = newText.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)newText);
        }
    }

    @Override
    public String substituteRecursively(String text, boolean caseSensitive) {
        for (String path : this.getPathIndex()) {
            String macro = this.get(path);
            text = ReplacePathToMacroMap.replacePathMacroRecursively(text, path, macro, caseSensitive);
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String replacePathMacroRecursively(String text, String path, String macro, boolean caseSensitive) {
        if (text.length() < path.length()) {
            return text;
        }
        if (path.length() == 0) {
            return text;
        }
        StringBuilder newText = StringBuilderSpinAllocator.alloc();
        try {
            boolean isWindowsRoot = path.endsWith(":/");
            int i = 0;
            while (i < text.length()) {
                int occurrenceOfPath;
                int n = occurrenceOfPath = caseSensitive ? text.indexOf(path, i) : StringUtil.indexOfIgnoreCase((String)text, (String)path, (int)i);
                if (occurrenceOfPath >= 0) {
                    int endOfOccurence = occurrenceOfPath + path.length();
                    if (!isWindowsRoot && endOfOccurence < text.length() && text.charAt(endOfOccurence) != '/' && text.charAt(endOfOccurence) != '\"' && text.charAt(endOfOccurence) != ' ' && !text.substring(endOfOccurence).startsWith("!/")) {
                        newText.append(text.substring(i, endOfOccurence));
                        i = endOfOccurence;
                        continue;
                    }
                }
                if (occurrenceOfPath < 0) {
                    if (newText.length() == 0) {
                        String string = text;
                        return string;
                    }
                    newText.append(text.substring(i));
                    break;
                }
                newText.append(text.substring(i, occurrenceOfPath));
                newText.append(macro);
                i = occurrenceOfPath + path.length();
            }
            String string = newText.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)newText);
        }
    }

    public List<String> getPathIndex() {
        if (this.myPathsIndex == null || this.myPathsIndex.size() != this.size()) {
            Set<Map.Entry<String, String>> entrySet = this.entries();
            Object[] entries = entrySet.toArray(new Map.Entry[entrySet.size()]);
            ContainerUtil.sort((Object[])entries, PATHS_COMPARATOR);
            this.myPathsIndex = new ArrayList<String>(entries.length);
            for (Object entry : entries) {
                this.myPathsIndex.add((String)entry.getKey());
            }
        }
        return this.myPathsIndex;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ReplacePathToMacroMap)) {
            return false;
        }
        return ((Object)this.myMacroMap).equals(((ReplacePathToMacroMap)obj).myMacroMap);
    }

    @Override
    public int hashCode() {
        return ((Object)this.myMacroMap).hashCode();
    }
}

