/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.codeStyle.CodeStyleSchemesPanel;
import com.intellij.application.options.codeStyle.CodeStyleSettingsListener;
import com.intellij.application.options.codeStyle.CodeStyleSettingsPanelFactory;
import com.intellij.application.options.codeStyle.LanguageSelector;
import com.intellij.application.options.codeStyle.LanguageSelectorListener;
import com.intellij.application.options.codeStyle.NewCodeStyleSettingsPanel;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.DetailsComponent;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.util.Alarm;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;

public class CodeStyleMainPanel
extends JPanel
implements LanguageSelectorListener {
    private final CardLayout myLayout = new CardLayout();
    private final JPanel mySettingsPanel = new JPanel(this.myLayout);
    private final Map<String, NewCodeStyleSettingsPanel> mySettingsPanels = new HashMap<String, NewCodeStyleSettingsPanel>();
    private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD);
    private final CodeStyleSchemesModel myModel;
    private final CodeStyleSettingsPanelFactory myFactory;
    private final CodeStyleSchemesPanel mySchemesPanel;
    private final LanguageSelector myLangSelector;
    @NonNls
    private static final String WAIT_CARD = "CodeStyleSchemesConfigurable.$$$.Wait.placeholder.$$$";

    public CodeStyleMainPanel(CodeStyleSchemesModel model, LanguageSelector langSelector, CodeStyleSettingsPanelFactory factory) {
        super(new BorderLayout());
        this.myModel = model;
        this.myFactory = factory;
        this.mySchemesPanel = new CodeStyleSchemesPanel(model);
        this.myLangSelector = langSelector;
        model.addListener(new CodeStyleSettingsListener(){

            @Override
            public void currentSchemeChanged(Object source) {
                if (source != CodeStyleMainPanel.this.mySchemesPanel) {
                    CodeStyleMainPanel.this.mySchemesPanel.onSelectedSchemeChanged();
                }
                CodeStyleMainPanel.this.onCurrentSchemeChanged();
            }

            @Override
            public void schemeListChanged() {
                CodeStyleMainPanel.this.mySchemesPanel.resetSchemesCombo();
            }

            @Override
            public void currentSettingsChanged() {
                CodeStyleMainPanel.this.ensureCurrentPanel().onSomethingChanged();
            }

            @Override
            public void usePerProjectSettingsOptionChanged() {
                CodeStyleMainPanel.this.mySchemesPanel.usePerProjectSettingsOptionChanged();
            }

            @Override
            public void schemeChanged(CodeStyleScheme scheme) {
                CodeStyleMainPanel.this.ensurePanel(scheme).resetFromClone();
            }
        });
        this.myLangSelector.addListener(this);
        this.addWaitCard();
        this.add((Component)this.mySchemesPanel.getPanel(), "North");
        DetailsComponent detComp = new DetailsComponent();
        detComp.setPaintBorder(false);
        detComp.setContent((JComponent)this.mySettingsPanel);
        detComp.setText(new String[]{this.getDisplayName()});
        this.add((Component)detComp.getComponent(), "Center");
        this.mySchemesPanel.resetSchemesCombo();
        this.mySchemesPanel.onSelectedSchemeChanged();
        this.onCurrentSchemeChanged();
    }

    private void addWaitCard() {
        JPanel waitPanel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(ApplicationBundle.message((String)"label.loading.page.please.wait", (Object[])new Object[0]));
        label.setHorizontalAlignment(0);
        waitPanel.add((Component)label, "Center");
        label.setCursor(Cursor.getPredefinedCursor(3));
        waitPanel.setCursor(Cursor.getPredefinedCursor(3));
        this.mySettingsPanel.add(WAIT_CARD, waitPanel);
    }

    public void onCurrentSchemeChanged() {
        this.myLayout.show(this.mySettingsPanel, WAIT_CARD);
        final Runnable replaceLayout = new Runnable(){

            @Override
            public void run() {
                CodeStyleMainPanel.this.ensureCurrentPanel().onSomethingChanged();
                CodeStyleMainPanel.this.myLayout.show(CodeStyleMainPanel.this.mySettingsPanel, CodeStyleMainPanel.this.myModel.getSelectedScheme().getName());
            }
        };
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            replaceLayout.run();
        } else {
            this.myAlarm.cancelAllRequests();
            Runnable request = new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(replaceLayout);
                }
            };
            this.myAlarm.addRequest(request, 200);
        }
    }

    public NewCodeStyleSettingsPanel[] getPanels() {
        Collection<NewCodeStyleSettingsPanel> panels = this.mySettingsPanels.values();
        return panels.toArray(new NewCodeStyleSettingsPanel[panels.size()]);
    }

    public boolean isModified() {
        NewCodeStyleSettingsPanel[] panels;
        for (NewCodeStyleSettingsPanel panel : panels = this.getPanels()) {
            if (!panel.isModified()) continue;
            return true;
        }
        return false;
    }

    public void reset() {
        for (NewCodeStyleSettingsPanel panel : this.mySettingsPanels.values()) {
            panel.reset();
        }
        this.onCurrentSchemeChanged();
    }

    private void clearPanels() {
        for (NewCodeStyleSettingsPanel panel : this.mySettingsPanels.values()) {
            panel.dispose();
        }
        this.mySettingsPanels.clear();
    }

    public void apply() {
        NewCodeStyleSettingsPanel[] panels;
        for (NewCodeStyleSettingsPanel panel : panels = this.getPanels()) {
            if (!panel.isModified()) continue;
            panel.apply();
        }
    }

    @NonNls
    public String getHelpTopic() {
        NewCodeStyleSettingsPanel selectedPanel = this.ensureCurrentPanel();
        if (selectedPanel == null) {
            return "reference.settingsdialog.IDE.globalcodestyle";
        }
        String helpTopic = selectedPanel.getHelpTopic();
        if (helpTopic != null) {
            return helpTopic;
        }
        return "";
    }

    private NewCodeStyleSettingsPanel ensureCurrentPanel() {
        return this.ensurePanel(this.myModel.getSelectedScheme());
    }

    private NewCodeStyleSettingsPanel ensurePanel(CodeStyleScheme scheme) {
        String name = scheme.getName();
        if (!this.mySettingsPanels.containsKey(name)) {
            NewCodeStyleSettingsPanel panel = this.myFactory.createPanel(scheme);
            panel.reset();
            panel.setModel(this.myModel);
            panel.setLanguageSelector(this.myLangSelector);
            this.mySettingsPanels.put(name, panel);
            this.mySettingsPanel.add(scheme.getName(), panel);
            this.mySchemesPanel.setCodeStyleSettingsPanel(panel);
        }
        return this.mySettingsPanels.get(name);
    }

    public String getDisplayName() {
        return this.myModel.getSelectedScheme().getName();
    }

    public void disposeUIResources() {
        this.myAlarm.cancelAllRequests();
        this.clearPanels();
        this.myLangSelector.removeListener(this);
    }

    public boolean isModified(CodeStyleScheme scheme) {
        if (!this.mySettingsPanels.containsKey(scheme.getName())) {
            return false;
        }
        return this.mySettingsPanels.get(scheme.getName()).isModified();
    }

    @Override
    public void languageChanged(Language lang) {
        for (NewCodeStyleSettingsPanel panel : this.mySettingsPanels.values()) {
            panel.setLanguage(lang);
        }
    }
}

