/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class ExpectedTypeUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.ExpectedTypeUtil");

    public static ExpectedTypeInfo[] intersect(List<ExpectedTypeInfo[]> typeInfos) {
        if (typeInfos.isEmpty()) {
            return ExpectedTypeInfo.EMPTY_ARRAY;
        }
        ExpectedTypeInfos result = new ExpectedTypeInfos(typeInfos.get(0));
        ExpectedTypeInfos acc = new ExpectedTypeInfos();
        for (int i = 1; i < typeInfos.size(); ++i) {
            ExpectedTypeInfo[] next = typeInfos.get(i);
            acc.clear();
            for (ExpectedTypeInfo info : next) {
                Iterator<ExpectedTypeInfo> iterator = result.iterator();
                while (iterator.hasNext()) {
                    ExpectedTypeInfo[] intersection;
                    for (ExpectedTypeInfo aIntersection : intersection = iterator.next().intersect(info)) {
                        acc.addInfo(aIntersection);
                    }
                }
            }
            if (acc.isEmpty()) {
                return ExpectedTypeInfo.EMPTY_ARRAY;
            }
            result = acc;
        }
        return result.toArray();
    }

    public static int contains(ExpectedTypeInfo info1, ExpectedTypeInfo info2) {
        int kind2;
        int kind1 = info1.getKind();
        if (kind1 == (kind2 = info2.getKind())) {
            if (ExpectedTypeUtil.matchesStrictly(info1.getType(), info2)) {
                return -1;
            }
            if (ExpectedTypeUtil.matchesStrictly(info2.getType(), info1)) {
                return 1;
            }
            return 0;
        }
        if (kind1 == 0) {
            return ExpectedTypeUtil.matches(info1.getType(), info2) ? -1 : 0;
        }
        if (kind2 == 0) {
            return ExpectedTypeUtil.matches(info2.getType(), info1) ? 1 : 0;
        }
        return 0;
    }

    private static boolean matchesStrictly(PsiType type, ExpectedTypeInfo info) {
        if (type instanceof PsiPrimitiveType != info.getType() instanceof PsiPrimitiveType) {
            return false;
        }
        return ExpectedTypeUtil.matches(type, info);
    }

    public static boolean matches(PsiType type, ExpectedTypeInfo info) {
        PsiType infoType = info.getType();
        switch (info.getKind()) {
            case 0: {
                return type.equals(infoType);
            }
            case 1: {
                return infoType.isAssignableFrom(type);
            }
            case 2: {
                return type.isAssignableFrom(infoType);
            }
        }
        LOG.error("Unexpected ExpectedInfo kind");
        return false;
    }

    @Nullable
    public static PsiSubstitutor inferSubstitutor(PsiMethod method, PsiMethodCallExpression callExpr, boolean forCompletion) {
        PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)method.getProject()).getResolveHelper();
        PsiParameter[] parameters = method.getParameterList().getParameters();
        PsiExpression[] args = callExpr.getArgumentList().getExpressions();
        PsiSubstitutor result = PsiSubstitutor.EMPTY;
        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)method.getContainingClass())) {
            PsiType type = helper.inferTypeForMethodTypeParameter(typeParameter, parameters, args, PsiSubstitutor.EMPTY, callExpr.getParent(), forCompletion);
            if (PsiType.NULL.equals(type)) {
                return null;
            }
            result = result.put(typeParameter, type);
        }
        return result;
    }

    public static class ExpectedClassesFromSetProvider
    implements ExpectedTypesProvider.ExpectedClassProvider {
        private final Set<PsiClass> myOccurrenceClasses;

        public ExpectedClassesFromSetProvider(Set<PsiClass> occurrenceClasses) {
            this.myOccurrenceClasses = occurrenceClasses;
        }

        @Override
        public PsiField[] findDeclaredFields(PsiManager manager, String name) {
            ArrayList<PsiField> fields = new ArrayList<PsiField>();
            for (PsiClass aClass : this.myOccurrenceClasses) {
                PsiField field = aClass.findFieldByName(name, true);
                if (field == null) continue;
                fields.add(field);
            }
            return fields.toArray(new PsiField[fields.size()]);
        }

        @Override
        public PsiMethod[] findDeclaredMethods(PsiManager manager, String name) {
            ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>();
            for (PsiClass aClass : this.myOccurrenceClasses) {
                PsiMethod[] occMethod = aClass.findMethodsByName(name, true);
                methods.addAll(Arrays.asList(occMethod));
            }
            return methods.toArray(new PsiMethod[methods.size()]);
        }
    }

    private static class ExpectedTypeInfos {
        List<ExpectedTypeInfo> myInfos;

        public ExpectedTypeInfos() {
            this.myInfos = new ArrayList<ExpectedTypeInfo>();
        }

        public ExpectedTypeInfos(ExpectedTypeInfo[] infos) {
            this.myInfos = new ArrayList<ExpectedTypeInfo>(Arrays.asList(infos));
        }

        public void clear() {
            this.myInfos.clear();
        }

        public void addInfo(ExpectedTypeInfo info) {
            Iterator<ExpectedTypeInfo> iterator = this.myInfos.iterator();
            while (iterator.hasNext()) {
                ExpectedTypeInfo sub = iterator.next();
                int cmp = ExpectedTypeUtil.contains(sub, info);
                if (cmp > 0) {
                    return;
                }
                if (cmp >= 0) continue;
                iterator.remove();
            }
            this.myInfos.add(info);
        }

        public boolean isEmpty() {
            return this.myInfos.isEmpty();
        }

        public Iterator<ExpectedTypeInfo> iterator() {
            return this.myInfos.iterator();
        }

        public ExpectedTypeInfo[] toArray() {
            return this.myInfos.toArray(new ExpectedTypeInfo[this.myInfos.size()]);
        }
    }
}

