/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TargetElementUtil
extends TargetElementUtilBase {
    public static final int NEW_AS_CONSTRUCTOR = 4;
    public static final int THIS_ACCEPTED = 16;
    public static final int SUPER_ACCEPTED = 32;

    @Override
    public int getAllAccepted() {
        return super.getAllAccepted() | 4 | 0x10 | 0x20;
    }

    @Override
    public int getDefinitionSearchFlags() {
        return super.getDefinitionSearchFlags() | 0x10 | 0x20;
    }

    @Override
    public int getReferenceSearchFlags() {
        return super.getReferenceSearchFlags() | 4;
    }

    @Override
    @Nullable
    public PsiElement findTargetElement(Editor editor, int flags, int offset) {
        PsiElement element = super.findTargetElement(editor, flags, offset);
        if (element instanceof PsiKeyword) {
            if (element.getParent() instanceof PsiThisExpression) {
                if ((flags & 0x10) == 0) {
                    return null;
                }
                PsiType type = ((PsiThisExpression)element.getParent()).getType();
                if (!(type instanceof PsiClassType)) {
                    return null;
                }
                return ((PsiClassType)type).resolve();
            }
            if (element.getParent() instanceof PsiSuperExpression) {
                if ((flags & 0x20) == 0) {
                    return null;
                }
                PsiType type = ((PsiSuperExpression)element.getParent()).getType();
                if (!(type instanceof PsiClassType)) {
                    return null;
                }
                return ((PsiClassType)type).resolve();
            }
        }
        return element;
    }

    @Override
    protected boolean isAcceptableReferencedElement(PsiElement element, PsiElement referenceOrReferencedElement) {
        return super.isAcceptableReferencedElement(element, referenceOrReferencedElement) && !TargetElementUtil.isEnumConstantReference(element, referenceOrReferencedElement);
    }

    private static boolean isEnumConstantReference(PsiElement element, PsiElement referenceOrReferencedElement) {
        return element != null && element.getParent() instanceof PsiEnumConstant && referenceOrReferencedElement instanceof PsiMethod && ((PsiMethod)referenceOrReferencedElement).isConstructor();
    }

    @Override
    @Nullable
    protected PsiElement getReferenceOrReferencedElement(PsiFile file, Editor editor, int flags, int offset) {
        PsiElement refElement = super.getReferenceOrReferencedElement(file, editor, flags, offset);
        PsiReference ref = null;
        if (refElement == null && (ref = TargetElementUtilBase.findReference(editor, offset)) instanceof PsiJavaReference) {
            refElement = ((PsiJavaReference)ref).advancedResolve(true).getElement();
        }
        if (refElement != null) {
            PsiFile containingFile;
            if ((flags & 4) != 0) {
                if (ref == null) {
                    ref = TargetElementUtilBase.findReference(editor, offset);
                }
                if (ref != null) {
                    PsiMethod constructor;
                    PsiElement parent = ref.getElement().getParent();
                    if (parent instanceof PsiAnonymousClass) {
                        parent = parent.getParent();
                    }
                    if (parent instanceof PsiNewExpression && (constructor = ((PsiNewExpression)parent).resolveConstructor()) != null) {
                        refElement = constructor;
                    }
                }
            }
            if (refElement instanceof PsiClass && (containingFile = refElement.getContainingFile()) != null && containingFile.getVirtualFile() == null) {
                String qualifiedName = ((PsiClass)refElement).getQualifiedName();
                if (qualifiedName == null) {
                    return null;
                }
                return JavaPsiFacade.getInstance((Project)refElement.getProject()).findClass(qualifiedName, refElement.getResolveScope());
            }
        }
        return refElement;
    }

    @Override
    protected PsiElement getNamedElement(PsiElement element) {
        PsiElement parent = element.getParent();
        if (element instanceof PsiIdentifier) {
            if (parent instanceof PsiClass && element.equals(((PsiClass)parent).getNameIdentifier())) {
                return parent;
            }
            if (parent instanceof PsiVariable && element.equals(((PsiVariable)parent).getNameIdentifier())) {
                return parent;
            }
            if (parent instanceof PsiMethod && element.equals(((PsiMethod)parent).getNameIdentifier())) {
                return parent;
            }
            if (parent instanceof PsiLabeledStatement && element.equals(((PsiLabeledStatement)parent).getLabelIdentifier())) {
                return parent;
            }
        } else {
            parent = PsiTreeUtil.getParentOfType((PsiElement)element, PsiNamedElement.class, (boolean)false);
            if (!(parent == null || parent.getTextOffset() != element.getTextRange().getStartOffset() || parent instanceof XmlAttribute || parent instanceof PsiFile && InjectedLanguageManager.getInstance((Project)parent.getProject()).isInjectedFragment((PsiFile)parent))) {
                return parent;
            }
        }
        return null;
    }

    @Nullable
    public static PsiReferenceExpression findReferenceExpression(Editor editor) {
        PsiReference ref = TargetElementUtil.findReference(editor);
        return ref instanceof PsiReferenceExpression ? (PsiReferenceExpression)ref : null;
    }

    @Override
    public PsiElement adjustReference(@NotNull PsiReference ref) {
        if (ref == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/TargetElementUtil.adjustReference must not be null");
        }
        PsiElement parent = ref.getElement().getParent();
        if (parent instanceof PsiMethodCallExpression) {
            return parent;
        }
        return super.adjustReference(ref);
    }

    @Override
    @Nullable
    public PsiElement adjustElement(Editor editor, int flags, PsiElement element, PsiElement contextElement) {
        if (element != null) {
            if (element instanceof PsiAnonymousClass) {
                return ((PsiAnonymousClass)element).getBaseClassType().resolve();
            }
            return element;
        }
        if (contextElement == null) {
            return null;
        }
        PsiElement parent = contextElement.getParent();
        if (parent instanceof XmlText || parent instanceof XmlAttributeValue) {
            return TargetElementUtilBase.getInstance().findTargetElement(editor, flags, parent.getParent().getTextRange().getStartOffset() + 1);
        }
        if (parent instanceof XmlTag || parent instanceof XmlAttribute) {
            return TargetElementUtilBase.getInstance().findTargetElement(editor, flags, parent.getTextRange().getStartOffset() + 1);
        }
        return null;
    }

    @Override
    public Collection<PsiElement> getTargetCandidates(PsiReference reference) {
        PsiElement parent = reference.getElement().getParent();
        if (parent instanceof PsiMethodCallExpression) {
            PsiElement referee;
            PsiMethodCallExpression callExpr = (PsiMethodCallExpression)parent;
            boolean allowStatics = false;
            PsiExpression qualifier = callExpr.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                allowStatics = true;
            } else if (qualifier instanceof PsiJavaCodeReferenceElement && (referee = ((PsiJavaCodeReferenceElement)qualifier).advancedResolve(true).getElement()) instanceof PsiClass) {
                allowStatics = true;
            }
            PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)parent.getProject()).getResolveHelper();
            PsiElement[] candidates = PsiUtil.mapElements((ResolveResult[])helper.getReferencedMethodCandidates((PsiCallExpression)callExpr, false));
            ArrayList<PsiElement> methods = new ArrayList<PsiElement>();
            for (PsiElement candidate1 : candidates) {
                PsiMethod candidate = (PsiMethod)candidate1;
                if (candidate.hasModifierProperty("static") && !allowStatics) continue;
                List<PsiMethod> supers = Arrays.asList(candidate.findSuperMethods());
                if (supers.isEmpty()) {
                    methods.add((PsiElement)candidate);
                    continue;
                }
                methods.addAll(supers);
            }
            return methods;
        }
        return super.getTargetCandidates(reference);
    }

    @Override
    public PsiElement getGotoDeclarationTarget(PsiElement element, PsiElement navElement) {
        PsiElement navClass;
        PsiClass aClass;
        PsiMethod method;
        if (navElement == element && element instanceof PsiCompiledElement && element instanceof PsiMethod && (method = (PsiMethod)element).isConstructor() && method.getParameterList().getParametersCount() == 0 && (aClass = method.getContainingClass()) != (navClass = aClass.getNavigationElement())) {
            return navClass;
        }
        return super.getGotoDeclarationTarget(element, navElement);
    }

    @Override
    public boolean includeSelfInGotoImplementation(PsiElement element) {
        if (element instanceof PsiModifierListOwner && ((PsiModifierListOwner)element).hasModifierProperty("abstract")) {
            return false;
        }
        return super.includeSelfInGotoImplementation(element);
    }
}

