/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.AutoCompletionContext;
import com.intellij.codeInsight.completion.AutoCompletionDecision;
import com.intellij.codeInsight.completion.CompletionContext;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.FileCopyPatcher;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.hint.EditorHintListener;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.DeferredUserLookupValue;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.extapi.psi.MetadataPsiElementBase;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.reference.SoftReference;
import com.intellij.ui.LightweightHint;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeCompletionHandlerBase
implements CodeInsightActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.CodeCompletionHandlerBase");
    private final CompletionType myCompletionType;
    public static final Key<SoftReference<PsiFile>> FILE_COPY_KEY = Key.create((String)"CompletionFileCopy");

    public CodeCompletionHandlerBase(CompletionType completionType) {
        this.myCompletionType = completionType;
    }

    public final void invoke(Project project, Editor editor) {
        this.invoke(project, editor, PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project));
    }

    public final void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/CodeCompletionHandlerBase.invoke must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/completion/CodeCompletionHandlerBase.invoke must not be null");
        }
        if (psiFile == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/completion/CodeCompletionHandlerBase.invoke must not be null");
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) assert (!ApplicationManager.getApplication().isWriteAccessAllowed());
        try {
            this.invokeCompletion(project, editor, psiFile, 1);
        }
        catch (IndexNotReadyException e) {
            DumbService.getInstance((Project)project).showDumbModeNotification("Code completion is not available here while indices are being built");
        }
    }

    public void invokeCompletion(final Project project, final Editor editor, final PsiFile psiFile, int time) {
        final Document document = editor.getDocument();
        if (editor.isViewer()) {
            document.fireReadOnlyModificationAttempt();
            return;
        }
        if (!FileDocumentManager.getInstance().requestWriting(document, project)) {
            return;
        }
        psiFile.putUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING, (Object)Boolean.TRUE);
        final CompletionProgressIndicator indicator = CompletionServiceImpl.getCompletionService().getCurrentCompletion();
        if (indicator != null) {
            if (indicator.getParameters().getCompletionType().equals((Object)this.myCompletionType) && editor == indicator.getEditor()) {
                if (!(indicator.isRunning() || this.isAutocompleteCommonPrefixOnInvocation() && !indicator.fillInCommonPrefix(true))) {
                    return;
                }
                time = indicator.getParameters().getInvocationCount() + 1;
                new WriteCommandAction(project, new PsiFile[0]){

                    protected void run(Result result) throws Throwable {
                        indicator.restorePrefix();
                    }
                }.execute();
            }
            indicator.closeAndFinish();
        }
        if (time != 1) {
            if (this.myCompletionType == CompletionType.CLASS_NAME) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.second.classname");
            } else if (this.myCompletionType == CompletionType.BASIC) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.second.basic");
            }
        }
        CompletionInitializationContext initializationContext = (CompletionInitializationContext)new WriteCommandAction<CompletionInitializationContext>(project, new PsiFile[0]){

            protected void run(Result<CompletionInitializationContext> result) throws Throwable {
                CommandProcessor.getInstance().setCurrentCommandGroupId(null);
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
                EditorUtil.fillVirtualSpaceUntilCaret(editor);
                documentManager.commitAllDocuments();
                CompletionInitializationContext initializationContext = new CompletionInitializationContext(editor, psiFile, CodeCompletionHandlerBase.this.myCompletionType);
                result.setResult((Object)initializationContext);
                for (CompletionContributor contributor : CompletionContributor.forLanguage((Language)PsiUtilBase.getLanguageInEditor((Editor)editor, (Project)project))) {
                    if (DumbService.getInstance((Project)project).isDumb() && !(contributor instanceof DumbAware)) continue;
                    contributor.beforeCompletion(initializationContext);
                    assert (!documentManager.isUncommited(document)) : "Contributor " + contributor + " left the document uncommitted";
                }
            }
        }.execute().getResultObject();
        int offset1 = initializationContext.getStartOffset();
        int offset2 = initializationContext.getSelectionEndOffset();
        CompletionContext context = new CompletionContext(project, editor, psiFile, initializationContext.getOffsetMap());
        this.doComplete(offset1, offset2, context, initializationContext.getFileCopyPatcher(), editor, time);
    }

    protected void doComplete(int offset1, int offset2, final CompletionContext context, final FileCopyPatcher patcher, final Editor editor, int invocationCount) {
        if (!ApplicationManager.getApplication().isUnitTestMode() && context.editor.getComponent().getRootPane() == null) {
            return;
        }
        Pair insertedInfo = (Pair)new WriteCommandAction<Pair<CompletionContext, PsiElement>>(context.project, new PsiFile[0]){

            protected void run(Result<Pair<CompletionContext, PsiElement>> result) throws Throwable {
                result.setResult((Object)CodeCompletionHandlerBase.this.insertDummyIdentifier(context, patcher));
            }
        }.execute().getResultObject();
        PsiElement insertedElement = (PsiElement)insertedInfo.getSecond();
        CompletionContext newContext = (CompletionContext)insertedInfo.getFirst();
        insertedElement.putUserData(CompletionContext.COMPLETION_CONTEXT_KEY, (Object)newContext);
        PsiFile originalFile = newContext.file;
        PsiFile rightLanguagedOriginal = originalFile.getViewProvider().getPsi(insertedElement.getContainingFile().getLanguage());
        if (rightLanguagedOriginal != null) {
            originalFile = rightLanguagedOriginal;
        }
        final CompletionParameters parameters = new CompletionParameters(insertedElement, originalFile, this.myCompletionType, newContext.getStartOffset(), invocationCount);
        final Semaphore freezeSemaphore = new Semaphore();
        freezeSemaphore.down();
        final CompletionProgressIndicator indicator = new CompletionProgressIndicator(editor, parameters, this, context, freezeSemaphore);
        final Ref data = Ref.create(null);
        final ModalityState modalityState = ModalityState.current();
        Runnable computeRunnable = new Runnable(){

            @Override
            public void run() {
                ProgressManager.getInstance().runProcess(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            LookupElement[] items = CompletionService.getCompletionService().performCompletion(parameters, (Consumer)new Consumer<LookupElement>(){

                                public void consume(LookupElement lookupElement) {
                                    indicator.addItem(lookupElement);
                                }
                            });
                            indicator.getLookup().setCalculating(false);
                            data.set((Object)items);
                            freezeSemaphore.up();
                            if (items.length == 0) {
                                ApplicationManager.getApplication().invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (indicator != CompletionServiceImpl.getCompletionService().getCurrentCompletion()) {
                                            return;
                                        }
                                        Lookup lookup = LookupManager.getActiveLookup(editor);
                                        assert (lookup == indicator.getLookup()) : lookup;
                                        indicator.closeAndFinish();
                                        if (editor.isDisposed()) {
                                            return;
                                        }
                                        CompletionProgressIndicator completion = CompletionServiceImpl.getCompletionService().getCurrentCompletion();
                                        assert (completion == null) : "1 this=" + indicator + "\ncurrent=" + completion;
                                        HintManager.getInstance().hideAllHints();
                                        completion = CompletionServiceImpl.getCompletionService().getCurrentCompletion();
                                        assert (completion == null) : "2 this=" + indicator + "\ncurrent=" + completion;
                                        CodeCompletionHandlerBase.this.handleEmptyLookup(context, parameters, indicator);
                                    }
                                }, modalityState);
                            }
                        }
                        catch (ProcessCanceledException processCanceledException) {
                            // empty catch block
                        }
                    }
                }, (ProgressIndicator)indicator);
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            computeRunnable.run();
            if (((LookupElement[])data.get()).length == 0) {
                indicator.closeAndFinish();
            }
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(computeRunnable);
            if (!freezeSemaphore.waitFor(2000L) || data.isNull()) {
                indicator.showLookup();
                return;
            }
        }
        this.completionFinished(offset1, offset2, context, indicator, (LookupElement[])data.get());
    }

    private AutoCompletionDecision shouldAutoComplete(CompletionContext context, CompletionProgressIndicator indicator, LookupElement[] items) {
        if (!this.mayAutocompleteOnInvocation()) {
            return AutoCompletionDecision.SHOW_LOOKUP;
        }
        CompletionParameters parameters = indicator.getParameters();
        LookupElement item = items[0];
        if (items.length == 1) {
            AutoCompletionPolicy policy = CodeCompletionHandlerBase.getAutocompletionPolicy(item);
            if (policy == AutoCompletionPolicy.NEVER_AUTOCOMPLETE) {
                return AutoCompletionDecision.SHOW_LOOKUP;
            }
            if (policy == AutoCompletionPolicy.ALWAYS_AUTOCOMPLETE) {
                return AutoCompletionDecision.insertItem((LookupElement)item);
            }
        }
        if (!CodeCompletionHandlerBase.isAutocompleteOnInvocation(parameters.getCompletionType())) {
            return AutoCompletionDecision.SHOW_LOOKUP;
        }
        if (CodeCompletionHandlerBase.isInsideIdentifier(context.getOffsetMap())) {
            return AutoCompletionDecision.SHOW_LOOKUP;
        }
        if (items.length == 1 && CodeCompletionHandlerBase.getAutocompletionPolicy(item) == AutoCompletionPolicy.GIVE_CHANCE_TO_OVERWRITE) {
            return AutoCompletionDecision.insertItem((LookupElement)item);
        }
        for (CompletionContributor contributor : CompletionContributor.forParameters((CompletionParameters)parameters)) {
            AutoCompletionDecision decision = contributor.handleAutoCompletionPossibility(new AutoCompletionContext(parameters, items, context.getOffsetMap()));
            if (decision == null) continue;
            return decision;
        }
        return AutoCompletionDecision.SHOW_LOOKUP;
    }

    @Nullable
    private static AutoCompletionPolicy getAutocompletionPolicy(LookupElement element) {
        AutoCompletionPolicy policy = AutoCompletionPolicy.getPolicy((LookupElement)element);
        if (policy != null) {
            return policy;
        }
        LookupItem item = (LookupItem)element.as(LookupItem.class);
        if (item != null) {
            return item.getAutoCompletionPolicy();
        }
        return null;
    }

    private static boolean isInsideIdentifier(OffsetMap offsetMap) {
        return offsetMap.getOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET) != offsetMap.getOffset(CompletionInitializationContext.SELECTION_END_OFFSET);
    }

    protected void completionFinished(int offset1, int offset2, CompletionContext context, CompletionProgressIndicator indicator, LookupElement[] items) {
        if (items.length == 0) {
            return;
        }
        AutoCompletionDecision decision = this.shouldAutoComplete(context, indicator, items);
        if (decision == AutoCompletionDecision.SHOW_LOOKUP) {
            indicator.showLookup();
            if (this.isAutocompleteCommonPrefixOnInvocation() && items.length > 1) {
                indicator.fillInCommonPrefix(false);
            }
        } else if (decision instanceof AutoCompletionDecision.InsertItem) {
            LookupElement item = ((AutoCompletionDecision.InsertItem)decision).getElement();
            indicator.closeAndFinish();
            indicator.rememberDocumentState();
            context.setStartOffset(offset1 - item.getPrefixMatcher().getPrefix().length());
            CodeCompletionHandlerBase.handleSingleItem(offset2, context, items, item.getLookupString(), item);
            indicator.liveAfterDeath(null);
        }
    }

    protected static void handleSingleItem(final int offset2, final CompletionContext context, final LookupElement[] items, final String _uniqueText, final LookupElement item) {
        new WriteCommandAction(context.project, new PsiFile[0]){

            protected void run(Result result) throws Throwable {
                String uniqueText = _uniqueText;
                if (item.getObject() instanceof DeferredUserLookupValue && item instanceof LookupItem) {
                    if (!((DeferredUserLookupValue)item.getObject()).handleUserSelection((LookupItem)item, context.project)) {
                        return;
                    }
                    uniqueText = item.getLookupString();
                }
                if (!StringUtil.startsWithIgnoreCase((String)uniqueText, (String)item.getPrefixMatcher().getPrefix())) {
                    FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.camelHumps");
                }
                CodeCompletionHandlerBase.insertLookupString(context, offset2, uniqueText);
                context.editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                CodeCompletionHandlerBase.lookupItemSelected(context, item, '\u0000', Arrays.asList(items));
            }
        }.execute();
    }

    private static void insertLookupString(CompletionContext context, int currentOffset, String newText) {
        Editor editor = context.editor;
        editor.getDocument().replaceString(context.getStartOffset(), currentOffset, (CharSequence)newText);
        editor.getCaretModel().moveToOffset(context.getStartOffset() + newText.length());
        editor.getSelectionModel().removeSelection();
    }

    protected static void selectLookupItem(LookupElement item, char completionChar, CompletionContext context, List<LookupElement> items) {
        int caretOffset = context.editor.getCaretModel().getOffset();
        context.setSelectionEndOffset(caretOffset);
        int idEnd = context.getOffsetMap().getOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET);
        int identifierEndOffset = CompletionUtil.isOverwrite(item, completionChar) && context.getSelectionEndOffset() == idEnd ? caretOffset : Math.max(caretOffset, idEnd);
        context.getOffsetMap().addOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET, identifierEndOffset);
        CodeCompletionHandlerBase.lookupItemSelected(context, item, completionChar, items);
    }

    private Pair<CompletionContext, PsiElement> insertDummyIdentifier(CompletionContext context, FileCopyPatcher patcher) {
        PsiElement element;
        PsiFile oldFileCopy = this.createFileCopy(context.file);
        PsiFile hostFile = InjectedLanguageUtil.getTopLevelFile((PsiElement)oldFileCopy);
        boolean wasInjected = hostFile != oldFileCopy;
        Project project = hostFile.getProject();
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)project);
        int hostStartOffset = injectedLanguageManager == null ? context.getStartOffset() : injectedLanguageManager.injectedToHost((PsiElement)oldFileCopy, context.getStartOffset());
        Document document = oldFileCopy.getViewProvider().getDocument();
        assert (document != null);
        patcher.patchFileCopy(oldFileCopy, document, context.getOffsetMap());
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        PsiFile fileCopy = InjectedLanguageUtil.findInjectedPsiNoCommit(hostFile, hostStartOffset);
        if (fileCopy == null) {
            PsiElement elementAfterCommit = CodeCompletionHandlerBase.findElementAt(hostFile, hostStartOffset);
            if (wasInjected) {
                LOG.error("No injected fragmnent found at offset " + hostStartOffset + " in the patched file copy, found: " + elementAfterCommit);
            }
            PsiFile psiFile = fileCopy = elementAfterCommit == null ? oldFileCopy : elementAfterCommit.getContainingFile();
        }
        if (oldFileCopy != fileCopy && !wasInjected) {
            Editor oldEditor = context.editor;
            Editor editor = EditorFactory.getInstance().createEditor(document, project);
            Editor newEditor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor, hostFile, context.getStartOffset());
            if (newEditor instanceof EditorWindow) {
                int toHost;
                EditorWindow injectedEditor = (EditorWindow)newEditor;
                PsiFile injectedFile = injectedEditor.getInjectedFile();
                OffsetMap map = new OffsetMap(newEditor.getDocument());
                OffsetMap oldMap = context.getOffsetMap();
                for (OffsetKey key : oldMap.keySet()) {
                    map.addOffset(key, injectedEditor.logicalPositionToOffset(injectedEditor.hostToInjected(oldEditor.offsetToLogicalPosition(oldMap.getOffset(key)))));
                }
                CompletionContext newContext = new CompletionContext(context.project, injectedEditor, injectedFile, map);
                int injectedOffset = newContext.getStartOffset();
                PsiElement element2 = CodeCompletionHandlerBase.findElementAt(injectedFile, injectedOffset);
                int n = toHost = injectedLanguageManager == null ? hostStartOffset : injectedLanguageManager.injectedToHost((PsiElement)injectedFile, injectedOffset);
                if (element2 != null && toHost == hostStartOffset) {
                    EditorFactory.getInstance().releaseEditor(editor);
                    return Pair.create((Object)newContext, (Object)element2);
                }
                PsiElement elementAfterCommit = CodeCompletionHandlerBase.findElementAt(hostFile, hostStartOffset);
                fileCopy = elementAfterCommit == null ? oldFileCopy : elementAfterCommit.getContainingFile();
            }
            EditorFactory.getInstance().releaseEditor(editor);
        }
        if ((element = CodeCompletionHandlerBase.findElementAt(fileCopy, context.getStartOffset())) == null) {
            LOG.error("offset " + context.getStartOffset() + " at:\ntext=\"" + fileCopy.getText() + "\"\ninstance=" + fileCopy);
        }
        return Pair.create((Object)context, (Object)element);
    }

    private static PsiElement findElementAt(PsiFile fileCopy, int startOffset) {
        PsiElement source;
        PsiElement element = fileCopy.findElementAt(startOffset);
        if (element instanceof MetadataPsiElementBase && (source = ((MetadataPsiElementBase)element).getSourceElement()) != null) {
            return source.findElementAt(startOffset - source.getTextRange().getStartOffset());
        }
        return element;
    }

    protected boolean mayAutocompleteOnInvocation() {
        return true;
    }

    protected boolean isAutocompleteCommonPrefixOnInvocation() {
        return CodeInsightSettings.getInstance().AUTOCOMPLETE_COMMON_PREFIX;
    }

    protected void handleEmptyLookup(CompletionContext context, CompletionParameters parameters, final CompletionProgressIndicator indicator) {
        DaemonCodeAnalyzer codeAnalyzer;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        Project project = context.project;
        Editor editor = context.editor;
        if (!ApplicationManager.getApplication().isUnitTestMode() && context.editor.getComponent().getRootPane() == null) {
            LOG.error("null root pane");
        }
        for (CompletionContributor contributor : CompletionContributor.forParameters((CompletionParameters)parameters)) {
            String text = contributor.handleEmptyLookup(parameters, editor);
            if (!StringUtil.isNotEmpty((String)text)) continue;
            EditorHintListener listener = new EditorHintListener(){

                @Override
                public void hintShown(Project project, LightweightHint hint, int flags) {
                    indicator.liveAfterDeath(hint);
                }
            };
            MessageBusConnection connection = context.project.getMessageBus().connect();
            connection.subscribe(EditorHintListener.TOPIC, (Object)listener);
            HintManager.getInstance().showErrorHint(editor, text);
            connection.disconnect();
            break;
        }
        if ((codeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)project)) != null) {
            codeAnalyzer.updateVisibleHighlighters(editor);
        }
    }

    private static void lookupItemSelected(final CompletionContext context, final @NotNull LookupElement item, final char completionChar, List<LookupElement> items) {
        if (item == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/completion/CodeCompletionHandlerBase.lookupItemSelected must not be null");
        }
        final Editor editor = context.editor;
        PsiFile file = context.file;
        final InsertionContext context1 = new InsertionContext(context.getOffsetMap(), completionChar, items.toArray(new LookupElement[items.size()]), file, editor);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                int idEndOffset = context.getOffsetMap().getOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET);
                if (idEndOffset != context.getSelectionEndOffset() && CompletionUtil.isOverwrite(item, completionChar)) {
                    editor.getDocument().deleteString(context.getSelectionEndOffset(), idEndOffset);
                }
                PsiDocumentManager.getInstance((Project)context.project).commitAllDocuments();
                item.handleInsert(context1);
                PostprocessReformattingAspect.getInstance(context.project).doPostponedFormatting();
                if (context1.shouldAddCompletionChar() && completionChar != '\u0000' && completionChar != '\t' && completionChar != '\n' && completionChar != '\r') {
                    TailType.insertChar((Editor)editor, (int)context1.getTailOffset(), (char)completionChar);
                }
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
        });
        final Runnable runnable = context1.getLaterRunnable();
        if (runnable != null) {
            Runnable runnable1 = new Runnable(){

                @Override
                public void run() {
                    Project project = context1.getProject();
                    if (project.isDisposed()) {
                        return;
                    }
                    runnable.run();
                }
            };
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                ApplicationManager.getApplication().invokeLater(runnable1);
            } else {
                runnable1.run();
            }
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    protected PsiFile createFileCopy(PsiFile file) {
        block11: {
            PsiFile copy;
            SoftReference reference;
            VirtualFile virtualFile = file.getVirtualFile();
            if (file.isPhysical() && virtualFile != null && virtualFile.getFileSystem() == LocalFileSystem.getInstance() && !InjectedLanguageManager.getInstance((Project)file.getProject()).isInjectedFragment(file) && (reference = (SoftReference)file.getUserData(FILE_COPY_KEY)) != null && (copy = (PsiFile)reference.get()) != null && copy.isValid() && copy.getClass().equals(file.getClass())) {
                Document document = copy.getViewProvider().getDocument();
                assert (document != null);
                String oldDocumentText = document.getText();
                String oldCopyText = copy.getText();
                String newText = file.getText();
                document.setText((CharSequence)newText);
                try {
                    PsiDocumentManager.getInstance((Project)copy.getProject()).commitDocument(document);
                    return copy;
                }
                catch (Throwable e) {
                    document.setText((CharSequence)"");
                    if (!((ApplicationEx)ApplicationManager.getApplication()).isInternal()) break block11;
                    StringBuilder sb = new StringBuilder();
                    boolean oldsAreSame = Comparing.equal((String)oldCopyText, (String)oldDocumentText);
                    if (oldsAreSame) {
                        sb.append("oldCopyText == oldDocumentText");
                    } else {
                        sb.append("oldCopyText != oldDocumentText");
                        sb.append("\n--- oldCopyText ------------------------------------------------\n").append(oldCopyText);
                        sb.append("\n--- oldDocumentText ------------------------------------------------\n").append(oldDocumentText);
                    }
                    if (Comparing.equal((String)oldCopyText, (String)newText)) {
                        sb.insert(0, "newText == oldCopyText; ");
                    } else if (!oldsAreSame && Comparing.equal((String)oldDocumentText, (String)newText)) {
                        sb.insert(0, "newText == oldDocumentText; ");
                    } else {
                        sb.insert(0, "newText != oldCopyText, oldDocumentText; ");
                        if (oldsAreSame) {
                            sb.append("\n--- oldCopyText ------------------------------------------------\n").append(oldCopyText);
                        }
                        sb.append("\n--- newText ------------------------------------------------\n").append(newText);
                    }
                    LOG.error(sb.toString(), e);
                }
            }
        }
        PsiFile copy = (PsiFile)file.copy();
        file.putUserData(FILE_COPY_KEY, (Object)new SoftReference((Object)copy));
        return copy;
    }

    public static boolean isAutocompleteOnInvocation(CompletionType type) {
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        switch (type) {
            case CLASS_NAME: {
                return settings.AUTOCOMPLETE_ON_CLASS_NAME_COMPLETION;
            }
            case SMART: {
                return settings.AUTOCOMPLETE_ON_SMART_TYPE_COMPLETION;
            }
        }
        return settings.AUTOCOMPLETE_ON_CODE_COMPLETION;
    }
}

