/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.util.Processor;

public class CompletionReferenceProcessor {
    public static final CompletionReferenceProcessor INSTANCE = new CompletionReferenceProcessor();

    protected CompletionReferenceProcessor() {
    }

    public final boolean processReferences(CompletionParameters parameters, Processor<LookupElement> processor) {
        PsiReference reference = parameters.getPosition().getContainingFile().findReferenceAt(parameters.getOffset());
        return reference == null || this.processReferenceVariants(reference, this.createReferenceProcessor(processor));
    }

    protected Processor<PsiReference> createReferenceProcessor(final Processor<LookupElement> processor) {
        return new Processor<PsiReference>(){

            public boolean process(PsiReference reference) {
                Object[] variants = reference.getVariants();
                assert (variants != null) : reference;
                for (Object variant : variants) {
                    if (processor.process((Object)CompletionData.objectToLookupItem(variant))) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public boolean processReferenceVariants(PsiReference reference, Processor<PsiReference> processor) {
        if (reference instanceof PsiMultiReference) {
            return this.processMultiReference((PsiMultiReference)reference, processor);
        }
        return processor.process((Object)reference);
    }

    protected boolean processMultiReference(PsiMultiReference multiReference, Processor<PsiReference> processor) {
        PsiReference[] references = multiReference.getReferences();
        boolean hasHard = CompletionReferenceProcessor.hasHardReference(references);
        for (PsiReference reference : references) {
            if (hasHard && reference.isSoft() || this.processReferenceVariants(reference, processor)) continue;
            return false;
        }
        return true;
    }

    protected static boolean hasHardReference(PsiReference[] references) {
        for (PsiReference reference : references) {
            if (reference.isSoft()) continue;
            return true;
        }
        return false;
    }
}

