/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.BasicExpressionCompletionContributor;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaChainLookupElement;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.JavaSmartCompletionParameters;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.SmartCompletionDecorator;
import com.intellij.codeInsight.lookup.ExpressionLookupItem;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ClassFilter;
import com.intellij.psi.filters.ElementExtractorFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.TrueFilter;
import com.intellij.psi.filters.element.ModifierFilter;
import com.intellij.psi.filters.types.AssignableFromFilter;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Icons;
import com.intellij.util.IncorrectOperationException;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferenceExpressionCompletionContributor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.ReferenceExpressionCompletionContributor");
    private static final PsiMethodPattern OBJECT_METHOD_PATTERN = ((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName((ElementPattern)PsiJavaPatterns.string().oneOf(new String[]{"hashCode", "equals", "finalize", "wait", "notify", "notifyAll", "getClass", "clone", "toString"}))).definedInClass("java.lang.Object");
    private static final PrefixMatcher TRUE_MATCHER = new PrefixMatcher(""){

        public boolean prefixMatches(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/ReferenceExpressionCompletionContributor$1.prefixMatches must not be null");
            }
            return true;
        }

        @NotNull
        public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
            if (prefix == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/ReferenceExpressionCompletionContributor$1.cloneWithPrefix must not be null");
            }
            1 v0 = this;
            if (v0 == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/ReferenceExpressionCompletionContributor$1.cloneWithPrefix must not return null");
            }
            return v0;
        }
    };

    private ReferenceExpressionCompletionContributor() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static ElementFilter getReferenceFilter(PsiElement element, boolean allowRecursion) {
        ElementFilter filter;
        ElementFilter elementFilter;
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiReferenceExpression.class).withParent(PsiThrowStatement.class))).accepts((Object)element)) {
            elementFilter = TrueFilter.INSTANCE;
            if (elementFilter == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/ReferenceExpressionCompletionContributor.getReferenceFilter must not return null");
            return elementFilter;
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement(PsiAnnotationParameterList.class), PsiJavaPatterns.psiElement(PsiSwitchLabelStatement.class)}))).accepts((Object)element)) {
            elementFilter = new ElementExtractorFilter(new AndFilter((ElementFilter)new ClassFilter(PsiField.class), (ElementFilter)new ModifierFilter("static", "final")));
            if (elementFilter == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/ReferenceExpressionCompletionContributor.getReferenceFilter must not return null");
            return elementFilter;
        }
        if (!allowRecursion && (filter = JavaCompletionUtil.recursionFilter(element)) != null) {
            elementFilter = new ElementExtractorFilter(filter);
            if (elementFilter == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/ReferenceExpressionCompletionContributor.getReferenceFilter must not return null");
            return elementFilter;
        }
        elementFilter = TrueFilter.INSTANCE;
        if (elementFilter != null) return elementFilter;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/ReferenceExpressionCompletionContributor.getReferenceFilter must not return null");
    }

    public static void fillCompletionVariants(final JavaSmartCompletionParameters parameters, final CompletionResultSet result) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                final PsiElement element = parameters.getPosition();
                if (JavaSmartCompletionContributor.INSIDE_TYPECAST_EXPRESSION.accepts((Object)element)) {
                    return;
                }
                int offset = parameters.getOffset();
                final PsiReference reference = element.getContainingFile().findReferenceAt(offset);
                if (reference != null) {
                    ElementFilter filter = ReferenceExpressionCompletionContributor.getReferenceFilter(element, false);
                    for (LookupElement item : ReferenceExpressionCompletionContributor.completeFinalReference(element, reference, filter, parameters)) {
                        result.addElement(item);
                    }
                    boolean secondTime = parameters.getInvocationCount() >= 2;
                    for (LookupElement item : JavaSmartCompletionContributor.completeReference(element, reference, filter, false, parameters)) {
                        ReferenceExpressionCompletionContributor.addSingleArrayElementAccess(element, item, parameters, result);
                        if (!secondTime) continue;
                        ReferenceExpressionCompletionContributor.addSecondCompletionVariants(element, reference, item, parameters, result);
                    }
                    if (secondTime && !((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"."})).accepts((Object)element)) {
                        BasicExpressionCompletionContributor.processDataflowExpressionTypes(element, null, TRUE_MATCHER, new Consumer<LookupElement>(){

                            public void consume(LookupElement baseItem) {
                                ReferenceExpressionCompletionContributor.addSecondCompletionVariants(element, reference, baseItem, parameters, result);
                            }
                        });
                    }
                }
            }
        });
    }

    private static Set<LookupElement> completeFinalReference(final PsiElement element, PsiReference reference, ElementFilter filter, final JavaSmartCompletionParameters parameters) {
        Set<LookupElement> elements = JavaSmartCompletionContributor.completeReference(element, reference, new AndFilter(filter, new ElementFilter(){

            public boolean isAcceptable(Object o, PsiElement context) {
                if (o instanceof CandidateInfo) {
                    CandidateInfo info = (CandidateInfo)o;
                    PsiElement member = info.getElement();
                    PsiType expectedType = parameters.getExpectedType();
                    if (expectedType.equals(PsiType.VOID)) {
                        return member instanceof PsiMethod;
                    }
                    return AssignableFromFilter.isAcceptable(member, element, expectedType, info.getSubstitutor());
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }), false, parameters);
        for (LookupElement lookupElement : elements) {
            if (!(lookupElement.getObject() instanceof PsiMethod)) continue;
            JavaMethodCallElement item = (JavaMethodCallElement)lookupElement.as(JavaMethodCallElement.class);
            assert (item != null);
            PsiMethod method = (PsiMethod)lookupElement.getObject();
            if (!SmartCompletionDecorator.hasUnboundTypeParams(method)) continue;
            item.setInferenceSubstitutor(SmartCompletionDecorator.calculateMethodReturnTypeSubstitutor(method, parameters.getExpectedType()));
        }
        return elements;
    }

    private static void addSingleArrayElementAccess(PsiElement element, LookupElement item, JavaSmartCompletionParameters parameters, CompletionResultSet result) {
        PsiNewExpression newExpression;
        PsiExpression[] dimensions;
        PsiExpression expression;
        PsiLocalVariable variable;
        PsiType type;
        if (item.getObject() instanceof PsiLocalVariable && (type = (variable = (PsiLocalVariable)item.getObject()).getType()) instanceof PsiArrayType && parameters.getExpectedType().isAssignableFrom(((PsiArrayType)type).getComponentType()) && (expression = variable.getInitializer()) instanceof PsiNewExpression && (dimensions = (newExpression = (PsiNewExpression)expression).getArrayDimensions()).length == 1 && "1".equals(dimensions[0].getText()) && newExpression.getArrayInitializer() == null) {
            String text = variable.getName() + "[0]";
            PsiExpression conversion = ReferenceExpressionCompletionContributor.createExpression(text, element);
            result.addElement((LookupElement)new ExpressionLookupItem(conversion).setIcon(variable.getIcon(1)));
        }
    }

    private static PsiExpression createExpression(String text, PsiElement element) {
        return JavaPsiFacade.getInstance((Project)element.getProject()).getElementFactory().createExpressionFromText(text, element);
    }

    private static void addSecondCompletionVariants(PsiElement element, PsiReference reference, LookupElement baseItem, JavaSmartCompletionParameters parameters, CompletionResultSet result) {
        Object object = baseItem.getObject();
        try {
            String prefix;
            PsiType itemType = JavaCompletionUtil.getLookupElementType(baseItem);
            if (itemType instanceof PsiWildcardType) {
                itemType = ((PsiWildcardType)itemType).getExtendsBound();
            }
            if (itemType == null) {
                return;
            }
            PsiElement qualifier = JavaCompletionUtil.getQualifier(reference.getElement());
            PsiType expectedType = parameters.getExpectedType();
            if (!(OBJECT_METHOD_PATTERN.accepts(object) && !ReferenceExpressionCompletionContributor.allowGetClass(object, parameters) || itemType.equalsToText("java.lang.String"))) {
                ReferenceExpressionCompletionContributor.addChainedCallVariants(element, baseItem, result, itemType, expectedType, parameters);
            }
            if ((prefix = ReferenceExpressionCompletionContributor.getItemText(object)) == null) {
                return;
            }
            ReferenceExpressionCompletionContributor.addArraysAsListConversions(element, prefix, itemType, result, qualifier, expectedType);
            ReferenceExpressionCompletionContributor.addToArrayConversions(element, object, prefix, itemType, result, qualifier, expectedType);
            ReferenceExpressionCompletionContributor.addArrayMemberAccessors(element, prefix, itemType, qualifier, result, (PsiModifierListOwner)object, expectedType);
        }
        catch (IncorrectOperationException ignored) {
            // empty catch block
        }
    }

    private static void addArrayMemberAccessors(final PsiElement element, String prefix, PsiType itemType, PsiElement qualifier, CompletionResultSet result, PsiModifierListOwner object, PsiType expectedType) throws IncorrectOperationException {
        if (itemType instanceof PsiArrayType && expectedType.isAssignableFrom(((PsiArrayType)itemType).getComponentType())) {
            PsiExpression conversion = ReferenceExpressionCompletionContributor.createExpression(ReferenceExpressionCompletionContributor.getQualifierText(qualifier) + prefix + "[0]", element);
            ExpressionLookupItem item = new ExpressionLookupItem(conversion);
            String presentable = prefix + "[...]";
            item.setLookupString(prefix);
            item.setPresentableText(presentable);
            item.addLookupStrings(new String[]{prefix});
            item.setIcon(object.getIcon(1));
            item.setInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                public void handleInsert(InsertionContext context, LookupElement item) {
                    FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.second.smarttype.array.member");
                    Editor editor = context.getEditor();
                    int startOffset = context.getStartOffset();
                    Document document = editor.getDocument();
                    int tailOffset = startOffset + item.getLookupString().length();
                    String callSpace = ReferenceExpressionCompletionContributor.getSpace(CodeStyleSettingsManager.getSettings((Project)element.getProject()).SPACE_WITHIN_BRACKETS);
                    String access = "[" + callSpace + callSpace + "]";
                    document.insertString(tailOffset, (CharSequence)access);
                    editor.getCaretModel().moveToOffset(tailOffset + 1 + callSpace.length());
                }
            });
            result.addElement((LookupElement)item);
        }
    }

    private static boolean allowGetClass(Object object, JavaSmartCompletionParameters parameters) {
        if (!"getClass".equals(((PsiMethod)object).getName())) {
            return false;
        }
        PsiType type = parameters.getDefaultType();
        String canonicalText = type.getCanonicalText();
        if ("java.lang.ClassLoader".equals(canonicalText)) {
            return true;
        }
        return canonicalText.startsWith("java.lang.reflect.");
    }

    private static void addArraysAsListConversions(final PsiElement element, final String prefix, PsiType itemType, CompletionResultSet result, @Nullable PsiElement qualifier, PsiType expectedType) throws IncorrectOperationException {
        PsiType componentType = PsiUtil.extractIterableTypeParameter((PsiType)expectedType, (boolean)true);
        if (componentType == null || !(itemType instanceof PsiArrayType) || !componentType.isAssignableFrom(((PsiArrayType)itemType).getComponentType())) {
            return;
        }
        final String qualifierText = ReferenceExpressionCompletionContributor.getQualifierText(qualifier);
        PsiExpression conversion = ReferenceExpressionCompletionContributor.createExpression("java.util.Arrays.asList(" + qualifierText + prefix + ")", element);
        ExpressionLookupItem item = new ExpressionLookupItem(conversion);
        String presentable = "Arrays.asList(" + qualifierText + prefix + ")";
        item.setLookupString(StringUtil.isEmpty((String)qualifierText) ? presentable : prefix);
        item.setPresentableText(presentable);
        item.addLookupStrings(new String[]{prefix, presentable, "asList(" + prefix + ")"});
        item.setIcon(Icons.METHOD_ICON);
        item.setInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

            public void handleInsert(InsertionContext context, LookupElement item) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.second.smarttype.aslist");
                Editor editor = context.getEditor();
                int startOffset = context.getStartOffset();
                Document document = editor.getDocument();
                int tailOffset = startOffset + item.getLookupString().length();
                Project project = element.getProject();
                String callSpace = ReferenceExpressionCompletionContributor.getSpace(CodeStyleSettingsManager.getSettings((Project)project).SPACE_WITHIN_METHOD_CALL_PARENTHESES);
                String newText = "java.util.Arrays.asList(" + callSpace + qualifierText + prefix + callSpace + ")";
                document.replaceString(startOffset -= qualifierText.length(), tailOffset, (CharSequence)newText);
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
                try {
                    JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)file, startOffset, startOffset + "java.util.Arrays".length());
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
                PostprocessReformattingAspect.getInstance(project).doPostponedFormatting();
            }
        });
        result.addElement((LookupElement)item);
    }

    private static void addToArrayConversions(PsiElement element, Object object, String prefix, PsiType itemType, CompletionResultSet result, @Nullable PsiElement qualifier, PsiType expectedType) {
        String callSpace = ReferenceExpressionCompletionContributor.getSpace(CodeStyleSettingsManager.getSettings((Project)element.getProject()).SPACE_WITHIN_METHOD_CALL_PARENTHESES);
        PsiType componentType = PsiUtil.extractIterableTypeParameter((PsiType)itemType, (boolean)true);
        if (componentType == null || !(expectedType instanceof PsiArrayType)) {
            return;
        }
        PsiArrayType type = (PsiArrayType)expectedType;
        if (!type.getComponentType().isAssignableFrom(componentType) || componentType instanceof PsiClassType && ((PsiClassType)componentType).hasParameters()) {
            return;
        }
        String bracketSpace = ReferenceExpressionCompletionContributor.getSpace(CodeStyleSettingsManager.getSettings((Project)element.getProject()).SPACE_WITHIN_BRACKETS);
        if (object instanceof PsiVariable && !JavaCompletionUtil.containsMethodCalls(qualifier)) {
            PsiVariable variable = (PsiVariable)object;
            ReferenceExpressionCompletionContributor.addToArrayConversion(element, prefix, "new " + componentType.getCanonicalText() + "[" + bracketSpace + ReferenceExpressionCompletionContributor.getQualifierText(qualifier) + variable.getName() + ".size(" + callSpace + ")" + bracketSpace + "]", "new " + ReferenceExpressionCompletionContributor.getQualifierText(qualifier) + componentType.getPresentableText() + "[" + variable.getName() + ".size()]", result, qualifier);
        } else {
            boolean hasEmptyArrayField = false;
            PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type);
            if (psiClass != null) {
                for (PsiField field : psiClass.getAllFields()) {
                    boolean needQualify;
                    if (!field.hasModifierProperty("static") || !field.hasModifierProperty("final") || !JavaPsiFacade.getInstance((Project)field.getProject()).getResolveHelper().isAccessible((PsiMember)field, element, null) || !type.isAssignableFrom(field.getType()) || !ReferenceExpressionCompletionContributor.isEmptyArrayInitializer((PsiElement)field.getInitializer())) continue;
                    try {
                        needQualify = !field.isEquivalentTo(((PsiReferenceExpression)ReferenceExpressionCompletionContributor.createExpression(field.getName(), element)).resolve());
                    }
                    catch (IncorrectOperationException e) {
                        continue;
                    }
                    ReferenceExpressionCompletionContributor.addToArrayConversion(element, prefix, (needQualify ? field.getContainingClass().getQualifiedName() + "." : "") + field.getName(), (needQualify ? field.getContainingClass().getName() + "." : "") + field.getName(), result, qualifier);
                    hasEmptyArrayField = true;
                }
            }
            if (!hasEmptyArrayField) {
                ReferenceExpressionCompletionContributor.addToArrayConversion(element, prefix, "new " + componentType.getCanonicalText() + "[" + bracketSpace + "0" + bracketSpace + "]", "new " + componentType.getPresentableText() + "[0]", result, qualifier);
            }
        }
    }

    private static String getQualifierText(@Nullable PsiElement qualifier) {
        return qualifier == null ? "" : qualifier.getText() + ".";
    }

    private static void addChainedCallVariants(PsiElement place, LookupElement qualifierItem, CompletionResultSet result, PsiType qualifierType, PsiType expectedType, JavaSmartCompletionParameters parameters) throws IncorrectOperationException {
        String typeText;
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)place.getProject()).getElementFactory();
        JavaCodeFragment block = elementFactory.createCodeBlockCodeFragment((typeText = qualifierType instanceof PsiEllipsisType ? ((PsiEllipsisType)qualifierType).getComponentType().getCanonicalText() + "[]" : qualifierType.getCanonicalText()) + " xxx;xxx.xxx;", place, false);
        PsiElement secondChild = block.getChildren()[1];
        if (!(secondChild instanceof PsiExpressionStatement)) {
            LOG.error(typeText);
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)secondChild;
        PsiReferenceExpression mockRef = (PsiReferenceExpression)expressionStatement.getExpression();
        ElementFilter filter = ReferenceExpressionCompletionContributor.getReferenceFilter(place, true);
        for (LookupElement item : ReferenceExpressionCompletionContributor.completeFinalReference(place, (PsiReference)mockRef, filter, parameters)) {
            if (!ReferenceExpressionCompletionContributor.shoudChain(place, qualifierType, expectedType, item)) continue;
            result.addElement(JavaChainLookupElement.chainElements(qualifierItem, item));
        }
    }

    private static boolean shoudChain(PsiElement element, PsiType qualifierType, PsiType expectedType, LookupElement item) {
        if (item.getObject() instanceof PsiMethod) {
            PsiClassType classType;
            PsiClass psiClass;
            PsiMethod method = (PsiMethod)item.getObject();
            if (((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("toArray")).withParameterCount(1).definedInClass("java.util.Collection").accepts((Object)method)) {
                return false;
            }
            PsiMethod parentMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
            if (ReferenceExpressionCompletionContributor.isUselessObjectMethod(method, parentMethod, qualifierType)) {
                return false;
            }
            PsiType type = method.getReturnType();
            if (type instanceof PsiClassType && (psiClass = (classType = (PsiClassType)type).resolve()) instanceof PsiTypeParameter && method.getTypeParameterList() == psiClass.getParent()) {
                PsiTypeParameter typeParameter = (PsiTypeParameter)psiClass;
                if (typeParameter.getExtendsListTypes().length == 0) {
                    return false;
                }
                if (!expectedType.isAssignableFrom(TypeConversionUtil.typeParameterErasure((PsiTypeParameter)typeParameter))) {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean isUselessObjectMethod(PsiMethod method, PsiMethod parentMethod, PsiType qualifierType) {
        if (!OBJECT_METHOD_PATTERN.accepts((Object)method)) {
            return false;
        }
        if (OBJECT_METHOD_PATTERN.accepts((Object)parentMethod) && method.getName().equals(parentMethod.getName())) {
            return false;
        }
        return !"toString".equals(method.getName()) || !qualifierType.equalsToText("java.lang.StringBuffer") && !InheritanceUtil.isInheritor((PsiType)qualifierType, (String)"java.lang.AbstractStringBuilder");
    }

    private static void addToArrayConversion(PsiElement element, String prefix, @NonNls String expressionString, @NonNls String presentableString, CompletionResultSet result, PsiElement qualifier) {
        PsiExpression conversion;
        boolean callSpace = CodeStyleSettingsManager.getSettings((Project)element.getProject()).SPACE_WITHIN_METHOD_CALL_PARENTHESES;
        try {
            conversion = ReferenceExpressionCompletionContributor.createExpression(ReferenceExpressionCompletionContributor.getQualifierText(qualifier) + prefix + ".toArray(" + ReferenceExpressionCompletionContributor.getSpace(callSpace) + expressionString + ReferenceExpressionCompletionContributor.getSpace(callSpace) + ")", element);
        }
        catch (IncorrectOperationException e) {
            return;
        }
        ExpressionLookupItem item = new ExpressionLookupItem(conversion);
        item.setLookupString(prefix + ".toArray(" + ReferenceExpressionCompletionContributor.getSpace(callSpace) + expressionString + ReferenceExpressionCompletionContributor.getSpace(callSpace) + ")");
        item.setPresentableText(prefix + ".toArray(" + presentableString + ")");
        item.addLookupStrings(new String[]{presentableString});
        item.setIcon(Icons.METHOD_ICON);
        item.setInsertHandler((InsertHandler)new InsertHandler<LookupItem>(){

            public void handleInsert(InsertionContext context, LookupItem item) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.second.smarttype.toar");
                Editor editor = context.getEditor();
                int startOffset = context.getStartOffset();
                Document document = editor.getDocument();
                int tailOffset = startOffset + item.getLookupString().length();
                Project project = editor.getProject();
                PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
                try {
                    JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)file, startOffset, tailOffset);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
                PostprocessReformattingAspect.getInstance(project).doPostponedFormatting();
            }
        });
        result.addElement((LookupElement)item);
    }

    private static boolean isEmptyArrayInitializer(@Nullable PsiElement element) {
        if (element instanceof PsiNewExpression) {
            PsiExpression[] dimensions;
            PsiNewExpression expression = (PsiNewExpression)element;
            for (PsiExpression dimension : dimensions = expression.getArrayDimensions()) {
                if (dimension instanceof PsiLiteralExpression && "0".equals(dimension.getText())) continue;
                return false;
            }
            PsiArrayInitializerExpression initializer = expression.getArrayInitializer();
            return initializer == null || initializer.getInitializers().length <= 0;
        }
        return false;
    }

    @Nullable
    private static String getItemText(Object o) {
        if (o instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)o;
            PsiType type = method.getReturnType();
            if (PsiType.VOID.equals(type) || PsiType.NULL.equals(type)) {
                return null;
            }
            if (method.getParameterList().getParametersCount() > 0) {
                return null;
            }
            return method.getName() + "(" + ReferenceExpressionCompletionContributor.getSpace(CodeStyleSettingsManager.getSettings((Project)method.getProject()).SPACE_WITHIN_METHOD_CALL_PARENTHESES) + ")";
        }
        if (o instanceof PsiVariable) {
            return ((PsiVariable)o).getName();
        }
        return null;
    }

    private static String getSpace(boolean needSpace) {
        return needSpace ? " " : "";
    }
}

