/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoNextErrorHandler
implements CodeInsightActionHandler {
    private final boolean myGoForward;

    public GotoNextErrorHandler(boolean goForward) {
        this.myGoForward = goForward;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/GotoNextErrorHandler.invoke must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/GotoNextErrorHandler.invoke must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/GotoNextErrorHandler.invoke must not be null");
        }
        int caretOffset = editor.getCaretModel().getOffset();
        this.gotoNextError(project, editor, file, caretOffset);
    }

    public boolean startInWriteAction() {
        return false;
    }

    private void gotoNextError(Project project, Editor editor, PsiFile file, int caretOffset) {
        HighlightInfo infoToGo;
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getInstance(project);
        List<HighlightInfo> highlights = DaemonCodeAnalyzerImpl.getHighlights(editor.getDocument(), severityRegistrar.getSeverityByIndex(0), project);
        if (highlights.isEmpty()) {
            GotoNextErrorHandler.showMessageWhenNoHighlights(project, file, editor);
            return;
        }
        DaemonCodeAnalyzerSettings settings = DaemonCodeAnalyzerSettings.getInstance();
        if (settings.NEXT_ERROR_ACTION_GOES_TO_ERRORS_FIRST) {
            for (int idx = severityRegistrar.getSeveritiesCount() - 1; idx >= 0; --idx) {
                HighlightSeverity minSeverity = severityRegistrar.getSeverityByIndex(idx);
                List<HighlightInfo> errors = DaemonCodeAnalyzerImpl.getHighlights(editor.getDocument(), minSeverity, project);
                if (errors.isEmpty()) continue;
                highlights = errors;
                break;
            }
        }
        if ((infoToGo = this.findInfoToGo(editor, caretOffset, highlights, true)) == null) {
            infoToGo = this.findInfoToGo(editor, caretOffset, highlights, false);
        }
        if (infoToGo != null) {
            GotoNextErrorHandler.navigateToError(project, editor, infoToGo);
        }
    }

    @Nullable
    private HighlightInfo findInfoToGo(Editor editor, int caretOffset, List<HighlightInfo> highlights, boolean skip) {
        int offsetToGo;
        int offsetToGoIfNoLuck = offsetToGo = this.myGoForward ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        HighlightInfo infoToGo = null;
        HighlightInfo infoToGoIfNoLuck = null;
        int caretOffsetIfNoLuck = this.myGoForward ? -1 : editor.getDocument().getTextLength();
        for (HighlightInfo info : highlights) {
            if (skip && SeverityRegistrar.skipSeverity(info.getSeverity())) continue;
            int startOffset = GotoNextErrorHandler.getNavigationPositionFor(info, editor.getDocument());
            if (this.isBetter(caretOffset, offsetToGo, startOffset)) {
                offsetToGo = startOffset;
                infoToGo = info;
            }
            if (!this.isBetter(caretOffsetIfNoLuck, offsetToGoIfNoLuck, startOffset)) continue;
            offsetToGoIfNoLuck = startOffset;
            infoToGoIfNoLuck = info;
        }
        if (infoToGo == null) {
            infoToGo = infoToGoIfNoLuck;
        }
        return infoToGo;
    }

    private boolean isBetter(int caretOffset, int offsetToGo, int startOffset) {
        return this.myGoForward ? startOffset > caretOffset && startOffset < offsetToGo : startOffset < caretOffset && startOffset > offsetToGo;
    }

    static void showMessageWhenNoHighlights(Project project, PsiFile file, Editor editor) {
        DaemonCodeAnalyzerImpl codeHighlighter = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)project);
        String message = codeHighlighter.isErrorAnalyzingFinished(file) ? InspectionsBundle.message((String)"no.errors.found.in.this.file", (Object[])new Object[0]) : InspectionsBundle.message((String)"error.analysis.is.in.progress", (Object[])new Object[0]);
        HintManager.getInstance().showInformationHint(editor, message);
    }

    static void navigateToError(Project project, final Editor editor, HighlightInfo info) {
        int oldOffset = editor.getCaretModel().getOffset();
        final int offset = GotoNextErrorHandler.getNavigationPositionFor(info, editor.getDocument());
        final int endOffset = info.highlighter.getEndOffset();
        final ScrollingModel scrollingModel = editor.getScrollingModel();
        if (offset != oldOffset) {
            ScrollType scrollType = offset > oldOffset ? ScrollType.CENTER_DOWN : ScrollType.CENTER_UP;
            editor.getSelectionModel().removeSelection();
            editor.getCaretModel().moveToOffset(offset);
            scrollingModel.scrollToCaret(scrollType);
        }
        scrollingModel.runActionOnScrollingFinished(new Runnable(){

            @Override
            public void run() {
                int maxOffset = editor.getDocument().getTextLength() - 1;
                if (maxOffset == -1) {
                    return;
                }
                scrollingModel.scrollTo(editor.offsetToLogicalPosition(Math.min(maxOffset, endOffset)), ScrollType.MAKE_VISIBLE);
                scrollingModel.scrollTo(editor.offsetToLogicalPosition(Math.min(maxOffset, offset)), ScrollType.MAKE_VISIBLE);
            }
        });
        IdeDocumentHistory.getInstance(project).includeCurrentCommandAsNavigation();
    }

    private static int getNavigationPositionFor(HighlightInfo info, Document document) {
        int start = info.highlighter.getStartOffset();
        if (start >= document.getTextLength()) {
            return document.getTextLength();
        }
        char c = document.getCharsSequence().charAt(start);
        int shift = info.isAfterEndOfLine && c != '\n' ? 1 : info.navigationShift;
        int offset = info.highlighter.getStartOffset() + shift;
        return Math.min(offset, document.getTextLength());
    }
}

