/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInsight.intention.impl.IntentionHintComponent;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.ide.DataManager;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.IntentionFilterOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ShowIntentionsPass
extends TextEditorHighlightingPass {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.ShowIntentionsPass");
    private final Editor myEditor;
    private final PsiFile myFile;
    private final int myPassIdToShowIntentionsFor;
    private final IntentionsInfo myIntentionsInfo;
    private volatile boolean myShowBulb;
    private volatile boolean myHasToRecreate;

    ShowIntentionsPass(@NotNull Project project, @NotNull Editor editor, int passId) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/ShowIntentionsPass.<init> must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/ShowIntentionsPass.<init> must not be null");
        }
        super(project, editor.getDocument(), false);
        this.myIntentionsInfo = new IntentionsInfo();
        this.myPassIdToShowIntentionsFor = passId;
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myEditor = editor;
        this.myFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
        assert (this.myFile != null) : FileDocumentManager.getInstance().getFile(this.myEditor.getDocument());
    }

    @Override
    public void doCollectInformation(ProgressIndicator progress) {
        if (!ApplicationManager.getApplication().isUnitTestMode() && !this.myEditor.getContentComponent().hasFocus()) {
            return;
        }
        TemplateState state = TemplateManagerImpl.getTemplateState(this.myEditor);
        if (state == null || state.isFinished()) {
            DaemonCodeAnalyzerImpl codeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)this.myProject);
            this.getIntentionActionsToShow();
            this.updateActions(codeAnalyzer);
        }
    }

    @Override
    public void doApplyInformationToEditor() {
        Point xy;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!ApplicationManager.getApplication().isUnitTestMode() && !this.myEditor.getContentComponent().hasFocus()) {
            return;
        }
        LogicalPosition caretPos = this.myEditor.getCaretModel().getLogicalPosition();
        Rectangle visibleArea = this.myEditor.getScrollingModel().getVisibleArea();
        if (!visibleArea.contains(xy = this.myEditor.logicalPositionToXY(caretPos))) {
            return;
        }
        TemplateState state = TemplateManagerImpl.getTemplateState(this.myEditor);
        if (this.myShowBulb && (state == null || state.isFinished()) && !HintManager.getInstance().hasShownHintsThatWillHideByOtherHint()) {
            DaemonCodeAnalyzerImpl codeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)this.myProject);
            codeAnalyzer.setLastIntentionHint(this.myProject, this.myFile, this.myEditor, this.myIntentionsInfo, this.myHasToRecreate);
        }
    }

    private void getIntentionActionsToShow() {
        if (LookupManager.getInstance(this.myProject).getActiveLookup() != null) {
            return;
        }
        ShowIntentionsPass.getActionsToShow(this.myEditor, this.myFile, this.myIntentionsInfo, this.myPassIdToShowIntentionsFor);
        if (this.myFile instanceof IntentionFilterOwner) {
            IntentionFilterOwner.IntentionActionsFilter actionsFilter = ((IntentionFilterOwner)this.myFile).getIntentionActionsFilter();
            if (actionsFilter == null) {
                return;
            }
            if (actionsFilter != IntentionFilterOwner.IntentionActionsFilter.EVERYTHING_AVAILABLE) {
                this.myIntentionsInfo.filterActions(actionsFilter);
            }
        }
        if (this.myIntentionsInfo.isEmpty()) {
            return;
        }
        boolean bl = this.myShowBulb = !this.myIntentionsInfo.guttersToShow.isEmpty();
        if (!this.myShowBulb) {
            for (HighlightInfo.IntentionActionDescriptor descriptor : ContainerUtil.concat((List[])new List[]{this.myIntentionsInfo.errorFixesToShow, this.myIntentionsInfo.inspectionFixesToShow, this.myIntentionsInfo.intentionsToShow})) {
                IntentionAction action = descriptor.getAction();
                if (!IntentionManagerSettings.getInstance().isShowLightBulb(action)) continue;
                this.myShowBulb = true;
                break;
            }
        }
    }

    private void updateActions(DaemonCodeAnalyzerImpl codeAnalyzer) {
        IntentionHintComponent hintComponent = codeAnalyzer.getLastIntentionHint();
        if (!this.myShowBulb || hintComponent == null) {
            return;
        }
        Boolean result = hintComponent.updateActions(this.myIntentionsInfo);
        if (result != null) {
            if (result == Boolean.FALSE) {
                this.myHasToRecreate = true;
            } else {
                this.myShowBulb = false;
            }
        }
    }

    public static void getActionsToShow(@NotNull Editor editor, @NotNull PsiFile psiFile, @NotNull IntentionsInfo intentions, int passIdToShowIntentionsFor) {
        Document document;
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/ShowIntentionsPass.getActionsToShow must not be null");
        }
        if (psiFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/ShowIntentionsPass.getActionsToShow must not be null");
        }
        if (intentions == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/ShowIntentionsPass.getActionsToShow must not be null");
        }
        PsiElement psiElement = psiFile.findElementAt(editor.getCaretModel().getOffset());
        LOG.assertTrue(psiElement == null || psiElement.isValid(), (Object)psiElement);
        int offset = editor.getCaretModel().getOffset();
        Project project = psiFile.getProject();
        for (IntentionAction action : IntentionManager.getInstance().getAvailableIntentionActions()) {
            Pair<PsiFile, Editor> place = ShowIntentionActionsHandler.availableFor(psiFile, editor, action, psiElement);
            if (place == null) continue;
            ArrayList<IntentionAction> enableDisableIntentionAction = new ArrayList<IntentionAction>();
            enableDisableIntentionAction.add(new IntentionHintComponent.EnableDisableIntentionAction(action));
            intentions.intentionsToShow.add(new HighlightInfo.IntentionActionDescriptor(action, enableDisableIntentionAction, null));
        }
        List<HighlightInfo.IntentionActionDescriptor> actions = QuickFixAction.getAvailableActions(editor, psiFile, passIdToShowIntentionsFor);
        DaemonCodeAnalyzer codeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)project);
        HighlightInfo infoAtCursor = ((DaemonCodeAnalyzerImpl)codeAnalyzer).findHighlightByOffset(document = editor.getDocument(), offset, true);
        if (infoAtCursor == null || infoAtCursor.getSeverity() == HighlightSeverity.ERROR) {
            intentions.errorFixesToShow.addAll(actions);
        } else {
            intentions.inspectionFixesToShow.addAll(actions);
        }
        int line = document.getLineNumber(offset);
        List<HighlightInfo> infoList = DaemonCodeAnalyzerImpl.getHighlights(document, HighlightSeverity.INFORMATION, project, document.getLineStartOffset(line), document.getLineEndOffset(line));
        for (HighlightInfo info : infoList) {
            String text;
            AnAction action;
            GutterIconRenderer renderer = info.getGutterIconRenderer();
            if (renderer == null || (action = renderer.getClickAction()) == null || (text = renderer.getTooltipText()) == null) continue;
            AbstractIntentionAction actionAdapter = new AbstractIntentionAction(){

                public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
                    if (project == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/ShowIntentionsPass$1.invoke must not be null");
                    }
                    RelativePoint relativePoint = JBPopupFactory.getInstance().guessBestPopupLocation(editor);
                    action.actionPerformed(new AnActionEvent((InputEvent)relativePoint.toMouseEvent(), DataManager.getInstance().getDataContext(), text, new Presentation(), ActionManager.getInstance(), 0));
                }

                @NotNull
                public String getText() {
                    String string = text;
                    if (string == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/ShowIntentionsPass$1.getText must not return null");
                    }
                    return string;
                }
            };
            intentions.guttersToShow.add(new HighlightInfo.IntentionActionDescriptor((IntentionAction)actionAdapter, Collections.<IntentionAction>emptyList(), text, renderer.getIcon()));
        }
    }

    public static class IntentionsInfo {
        public final List<HighlightInfo.IntentionActionDescriptor> intentionsToShow = new ArrayList<HighlightInfo.IntentionActionDescriptor>();
        public final List<HighlightInfo.IntentionActionDescriptor> errorFixesToShow = new ArrayList<HighlightInfo.IntentionActionDescriptor>();
        public final List<HighlightInfo.IntentionActionDescriptor> inspectionFixesToShow = new ArrayList<HighlightInfo.IntentionActionDescriptor>();
        public final List<HighlightInfo.IntentionActionDescriptor> guttersToShow = new ArrayList<HighlightInfo.IntentionActionDescriptor>();

        public void filterActions(@NotNull IntentionFilterOwner.IntentionActionsFilter actionsFilter) {
            if (actionsFilter == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/ShowIntentionsPass$IntentionsInfo.filterActions must not be null");
            }
            IntentionsInfo.filter(this.intentionsToShow, actionsFilter);
            IntentionsInfo.filter(this.errorFixesToShow, actionsFilter);
            IntentionsInfo.filter(this.inspectionFixesToShow, actionsFilter);
            IntentionsInfo.filter(this.guttersToShow, actionsFilter);
        }

        private static void filter(List<HighlightInfo.IntentionActionDescriptor> descriptors, IntentionFilterOwner.IntentionActionsFilter actionsFilter) {
            Iterator<HighlightInfo.IntentionActionDescriptor> it = descriptors.iterator();
            while (it.hasNext()) {
                HighlightInfo.IntentionActionDescriptor actionDescriptor = it.next();
                if (actionsFilter.isAvailable(actionDescriptor.getAction())) continue;
                it.remove();
            }
        }

        public boolean isEmpty() {
            return this.intentionsToShow.isEmpty() && this.errorFixesToShow.isEmpty() && this.inspectionFixesToShow.isEmpty() && this.guttersToShow.isEmpty();
        }

        public String toString() {
            return "Intentions: " + this.intentionsToShow + "; Errors: " + this.errorFixesToShow + "; Inspection fixes: " + this.inspectionFixesToShow + "; Gutters: " + this.guttersToShow;
        }
    }
}

